/*--------------------- revision history -----------------------------------
 * 14- 1-96 (JAD): Changed comment a bit.
 *  1- 3-93 (JAD): Created.
 *--------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "in7bn7io.h"

static void  savePrint(FILE *fo, MATRIX mXt, char **asX, int iT1, int iT2,
    int cX, char *sHeader, int lpp, int cpl)
{
    int  i, j, cline, ccol = (cpl - 12) / 13;
    int  hl = 0;
    int  hr = min(ccol, cX);


    if (cX == 0 || iT1 > iT2)
        return;

    lpp -= 3;                             /* overhead for header and titles */

    fprintf(fo, " --- Printed by PcGive ----\n\n");
    cline = 2;

    do         /* write cT x (hl...hr) block (ccol on line), until finished */
    {
        for (i = iT1; i <= iT2; ++i)             /* write iT1..iT2 x hl..hr */
        {
            if (i - iT1 == 0 || cline % lpp == 0)   /* new page or new vars */
            {
                if (cline == 2 || cline % lpp == 0)        /* yes: new page */
                {   if (i > iT1) fprintf(fo, "\f");
                    if (sHeader && *sHeader)
                        fprintf(fo, " %s\n\n", sHeader), cline += 2;
                }
                if (asX)
                {   fprintf(fo, "%12s", " ");
                    for (j = hl; j < hr; ++j)
                        fprintf(fo, " %12s", asX[j]);
                    fprintf(fo, "\n"), cline++;
                }
            }
            fprintf(fo, " %4d -%3d  ", IObsYear(i), IObsPeriod(i));
            for (j = hl; j < hr; ++j)
                if (mXt[j][i] == g_dMisval)
                    fprintf(fo, " %12s", "----");
                else
                    fprintf(fo, " %12.5g", mXt[j][i]);
            fprintf(fo, "\n"), cline++;
        }
        hr += ccol;         /* 1..iT2 x hl..hr block is done, do next block */
        if (hr > cX)  hr = cX;
        hl += ccol;
    } while (hl < cX);
}

void main(int argc, char *argv[])
{
    char *sinput = NULL, *soutput = NULL, sheader[160];
    FILE *fo;

    fprintf(stderr, "\nC Program to test reading and writing of PcGive datafiles.\n");
    fprintf(stderr, "Jurgen A Doornik, 1993-1997.\n\n");

                                                  /* check the command line */
    if (argc < 2 || argc > 3 || strcmp(argv[1], "?") == 0)
    {
        fprintf(stderr, "Usage: CTESTIO inputfile [outputfile]\n");
        return;
    }

    while (argc > 1)
    {
        --argc;  ++argv;       /* first argument is name of executable file */

        if (sinput == NULL)
            sinput = *argv;
        else
            soutput = *argv;
    }                       /* end of exploration of command line arguments */

    
	QuickLoadData(sinput, NULL);   /* load the data file as named in sinput */
							  /* data is loaded into the global struct g_db */

    sprintf(sheader, "Contents of %s", sinput);
    savePrint(stdout, g_db.mXt, g_db.asX, 0, g_db.cT - 1, g_db.cX, sheader, 60, 80);

    if (soutput)            /* for security: only save to non-existent file */
    {
        strcpy(sheader, soutput);                  /* append .IN7 extension */
        if (!*SFileExt(sheader))                 /* if no extension present */
            strcat(sheader, ".IN7");

        if ( (fo = fopen(sheader, "r")) != NULL)   /* try to open .IN7 file */
        {
            fclose(fo);
            fprintf(stderr, "\n%s already exists, nothing saved.\n", sheader);
            return;
        }
        
		QuickSaveData(soutput); /* save data which is in global struct g_db */
        fprintf(stderr, "\nData saved to %s.\n", sheader);
    }
}
