/*--------------------- revision history -----------------------------------
 * 14- 1-96 (JAD): Changed comment a bit.
 *  1- 3-93 (JAD): Created.
 *--------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "in7bn7io.h"


void main(int argc, char *argv[])
{
    int i;  char *soutput = "temp.in7";

    fprintf(stderr, "\nC Example program for creating and writing a PcGive datafile.\n");
    fprintf(stderr, "Writes a constant and a trend to temp.in7/bn7\n");
    fprintf(stderr, "Jurgen A Doornik, 1993-1997.\n\n");

	DbKill();                     /* only needed if database already exists */
       					          /* set database sample tp 1950(1)-1960(4) */
	g_db.sam.year1 = 1950;	g_db.sam.period1 = 1;
	g_db.sam.year2 = 1960;	g_db.sam.period2 = 4;
	g_db.iFreq = g_db.sam.freq = 4;				    /* set both frequencies */
	DbSetcT(IGetcT(&g_db.sam, g_db.sam.freq));      /* also set sample size */

	IDbAdd(2);			            /* create two variables in the database */
		             /* NB: return value is index of first created variable */
					 	          /* here we now these are variable 0 and 1 */
	for (i = 0; i < g_db.cT; ++i)
	{	g_db.mXt[0][i] = 1;					                    /* constant */
		g_db.mXt[1][i] = i + 1;					                   /* trend */
	}								                  /* set variable names */
    strcpy(g_db.asX[0], "constant");          /* NB: max length is NAME_LEN */
    strcpy(g_db.asX[1], "trend");             /* NB: max length is NAME_LEN */
		
	QuickSaveData(soutput);      /* save data which is in global struct g_db */
    fprintf(stderr, "\nData saved to %s.\n", soutput);
}
