/*--------------------- revision history -----------------------------------
 *  1- 3-93 (JAD): Created for linking to FORTRAN code
 *--------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "in7bn7io.h"

/*=========================== link to FORTRAN ==============================*/

/*-------------------------- DbIToF/DbSToF ---------------------------------
 *  QLData  calls QuickLoadData, loading all projects
 *  QSData  calls QuickSaveData, loading all projects
 *  DbIToF  copies the database information to the arguments
 *  DbSToF  copies a database data selection to the FORTRAN array
 *--------------------------------------------------------------------------*/
void _fortran QLData(char sFilename[], short int *piSlen)
{
    char sfname[80];  int len = min(79, *piSlen);

    strncpy(sfname, sFilename, len);
    sfname[len] = '\0';
    QuickLoadData(sfname, NULL);
}
void _fortran QSData(char sFilename[], short int *piSlen)
{
    char sfname[80];  int len = min(79, *piSlen);

    strncpy(sfname, sFilename, len);
    sfname[len] = '\0';
    QuickSaveData(sfname);
}
void _fortran DbFKill(void)
{
    DbKill();
}
void _fortran DbIToF(short int *pcX, short int *pcT, short int *piFreq,
    short int *piYear1, short int *piPeriod1, short int *piYear2,
    short int *piPeriod2)
{
    *pcT = db_.cT;  *pcX = db_.cX;  *piFreq = db_.iFreq;
    *piYear1 = db_.sam.year1;  *piPeriod1 = db_.sam.period1;
    *piYear2 = db_.sam.year2;  *piPeriod2 = db_.sam.period2;
}
void _fortran DbSToF(short int *piX1, short int *piX2, short int *piT1,
    short int *piT2, double *mXt, int *piXdim, int *piTdim)
{
    int i, j, k, m, ix1 = *piX1, ix2 = *piX2, it1 = *piT1, it2 = *piT2;

    *piX1 = *piX2 = *piT1 = *piT2 = 0;
    if (ix1 < 0)  ix1 = 0;
    if (ix2 >= db_.cX)  ix2 = db_.cX - 1;
    if (ix2 - ix1 + 1 > *piXdim)
        ix2 = *piXdim + ix1 - 1;
    if (ix1 >= db_.cX || ix1 > ix2)
        return;
    if (it1 < 0)  it1 = 0;
    if (it2 >= db_.cT)  it2 = db_.cT - 1;
    if (it1 >= db_.cT || it1 > it2)
        return;
    if (it2 - it1 + 1 > *piTdim)
        it2 = *piTdim + it1 - 1;

    for (i = ix1, k = 0; i <= ix2; i++, k += *piTdim)
        for (j = it1, m = 0; j <= it2; j++, m++)
            mXt[k + m] = db_.mXt[i][j];

    *piX1 = ix1; *piX2 = ix2; *piT1 = it1; *piT2 = it2;
}
/*-------------------------- END DbIToF/DbSToF -----------------------------*/

