/*--------------------------------------------------------------------------
 * dlstdio.h - definitions/declarations for high level screen I/O routines
 *
 *       Jurgen Doornik 1990-1991
 *
 *--------------------------------------------------------------------------*/

/*=========================== typedefs =====================================*/
#ifndef TYPES_DEFINED_
  #define TYPES_DEFINED_
  /* general typedefs                  prefix Hungarian Notation*/
  typedef unsigned char   byte;     /* b   */
#define bool jdbool
  typedef int             jdbool;   /* f,b */
#ifdef JD_LDOUBLE               /* on some machines long double is very slow */
  typedef long double     LDOUBLE;  /* ld  */  
#else
  typedef double          LDOUBLE;  /* ld  */  /* LDOUBLE defaults to double */
#endif
  typedef double **MATRIX;          /* m,mat */
  typedef double *VECTOR;           /* v,vec */

  struct sample
  {   int  year1, period1, year2, period2, freq;
  };
  typedef struct sample SAMPLE;
#endif

#ifndef FALSE
  #define  FALSE  0
  #define  TRUE   !FALSE
#endif

/*=========================== constants ====================================*/
                     /* Bit flags: FLAGi is that value with bit number i on */
#ifndef FLAG0
  #define  FLAG0    0x0001
  #define  FLAG1    0x0002
  #define  FLAG2    0x0004
  #define  FLAG3    0x0008
  #define  FLAG4    0x0010
  #define  FLAG5    0x0020
  #define  FLAG6    0x0040
  #define  FLAG7    0x0080
  #define  FLAG8    0x0100
  #define  FLAG9    0x0200
  #define  FLAG10   0x0400
  #define  FLAG11   0x0800
  #define  FLAG12   0x1000
  #define  FLAG13   0x2000
  #define  FLAG14   0x4000
  #define  FLAG15   0x8000
#endif

#if defined(DB_SMALL)
#define ABS_MX_OBS   4000                /* absolute max no of observations */
#define ABS_MX_VAR    100                   /* absolute max no of variables */
#else
#define ABS_MX_OBS  50000                /* absolute max no of observations */
#define ABS_MX_VAR    500                   /* absolute max no of variables */
#endif
#define NAME_LEN 11        /* max #chars in a variable name, excluding '\0' */
#define LAG_LEN 3         /* max #chars in lag length field, excluding '\0' */
#define DATAMARK ((double) (9999E99))      /* must be different from misval */

enum BinFlags
{   BIN_OLDGENERATION = FLAG0, BIN_SELECTED = FLAG1, BIN_DELETED = FLAG2
};
enum ReadWriteModes
{   RS_BINARY_SKIP, RS_ASCII_OBS, RS_ASCII_VAR, RS_BINARY_VAR,
    RS_PRINT_OBS,   RS_DIF
};

#define VERSION_NR 700

/*=========================== typedefs =====================================*/
struct IdxType
{
    struct IdxType *next;                   /* points to next entry in list */
    char  *sX;                                             /* variable name */
    int    iProject;                                      /* project number */
    int    iFreq;                                         /* data frequency */
    SAMPLE sam;                                            /* sample period */
    int    iGeneration;                                   /* var generation */
    int    flag;                                                /* var flag */
    long   lAddress;                                     /* address in file */
    char   sTime[13], sDate[13];                        /* date of variable */
    char   *sComment;                                /* one line of comment */
};

struct InfType
{
    char   sFilename[80];                                 /* data file name */
    char   sDatafile[80];                            /* .BIN data file name */
    char   *sComment;                                       /* file comment */
    int    iType;                                              /* file type */
    int    iFreqDb;                                  /* data-base frequency */
    SAMPLE samDb;                                /* data-base sample period */
    int    iFreq;                                /* selected data frequency */
    SAMPLE sam;                                   /* selected sample period */
    int    cX;                                           /* selection count */
    int    cT;                                    /* number of observations */
    int    cIdx;                                              /* item count */
    struct IdxType *pIdx;                                     /* index list */
    int    cProject;                                      /* no of projects */
    char   **asProject;                                    /* project array */
    int    iProject;                             /* selected project number */
};
struct SigType         /* 32 byte signature for every variable in .BN7 file */
{
    double    dSig;
    short int iDummy1, cT;
    char      sX[12];
    short int iFreq;
    short int iPeriod1;
    short int iYear1, iDummy2;
};
struct dbType
{
    int    mxX;                                      /* max no of variables */
    int    cX, cT;                                         /* var/obs count */
    VECTOR mXt[ABS_MX_VAR];                                  /* data matrix */
    char  *asX[ABS_MX_VAR];                                    /* var names */
    int    iFreq;                                         /* data frequency */
    SAMPLE sam;                                            /* sample period */
    bool   fChange;         /* TRUE if database variables have been changed */
    char   *sComment;                                  /* data-base comment */
    char   *asComment[ABS_MX_VAR];                      /* variable comment */
};

/*======================= external variables ===============================*/
extern struct dbType g_db;                                  /* the data base */
extern double g_dMisval;                                    /* missing value */

/*========================== macro's =======================================*/

/*============================ functions ===================================*/
/* in7bn7io.c */
bool FCheckCloseW(FILE *);
char *SFileBase(char *);
char *SFileExt(char *);
char *SDate(void);
char *STime(void);

int  DbSetcT(int);
void DbSetSam(int, SAMPLE);
void DbKill(void);
int  IDbAdd(int);
int  IDbDel(int);
int  IObsYear(int);
int  IObsPeriod(int);
int  IDateObs(int, int);
int  IGetcT(SAMPLE *, int);
void SetSampleEnd(SAMPLE *, int, int);
void SetSample(int, int, SAMPLE *);
void SetUnionSample(SAMPLE *, SAMPLE *, int);
char *SNameToken(char *);

int FReadBinary(FILE *, long, VECTOR, int, int, int, char *);
void DbToInf(struct InfType *);
bool FReadDataFile(struct InfType *);
bool FReadInfFile(struct InfType *, bool, bool);
bool FSaveDataFile(struct InfType *, bool);
bool FSaveInfFile(struct InfType *, bool);
struct IdxType *IdxAppend(struct InfType *, char *);
struct InfType *InfAlloc(char *);
void InfFree(struct InfType *);
void InfSample(struct InfType *);
void InfToDb(struct InfType *);
long LSaveBinary(FILE *, VECTOR, int, int, int, int, char *);
void SelectProject(struct InfType *, int);
bool FSetProject(char *, struct InfType *, struct IdxType *);

void QuickLoadData(char *, char *);
void QuickSaveData(char *);

