#include <oxstd.h>

Broy(const fun, const x0, ...){
//    Solution of simultaneous nonlinear equations in many variables
//    by Broyden's inverse Jacobian update method, full steps.
//    This implementation is NOT robust, but is efficient and simple.
//    With reasonably good starting values, the routine succeeds.
//    Programmed by N. Shamsundar, University of Houston, 10/1999
//
//    x=broy(fun,x0, ... Tol,FTol,Itermax)
//
//    Convergence test: norm(step) < Tol OR |f| < FTol
//

decl args=va_arglist();
decl n,nargin,ut,v,w,y,z,x,v1,s,k,Tol,FTol,Itmax,A;

nargin=sizeof(args);
n=sizer(x0);

// Set default parameters, if needed

if(nargin < 3) Tol=1e-4; else Tol=args[0];
if(nargin < 4) FTol=ones(n,1)*1e-4; else FTol=args[1];
if(nargin < 5) Itmax=100; else Itmax=args[2];

if(sizer(FTol) != n){
  println("Broy: FTol should be of same size as x");
  return 0;
  }

// Evaluate initial function value

x=x0; v=fun(x); 
if(sizer(x) != sizer(v)){
	println("   Equation m-file must return column vector");
	return 0;
	}

// Initialize inverse of Jacobian to identity

A=unit(n,n); s=-A*v; x+=s; k=2;

// Do Broyden iterations

while(k++ <= Itmax){
  w=v; v=fun(x); y=v-w;
  z=-A*y; ut=s'*A; A=A-(s+z)*ut/(s'*z);
  s=-A*v; x=x+s;
  if(norm(s) < Tol || fabs(v) < FTol){
     return x;
     }
  }

println("Maximum number of iterations exceeded in broy");
exit(1);
}

