// ODE45 usage example
// Solve the Blasius equation (from boundary-layer theory in fluid mechanics)
//       2f'''+ff''=0,
//    with initial conditions
//       f(0)=0, f'(0)=0, f''(0)=0.33206
//    over (0,10).
//
#include <oxstd.h>
#include <oxfloat.h>
#import "ODE45"

fnc(const t,const x){
return x[1] | x[2] | -0.5*x[0]*x[2];
}

main(){
decl a=0,b=10,x0=<0,0,0.33206>',FTol=<1e-6;1e-6;1e-6>,
	MaxStps=50,h=0.5;
decl odeout;
odeout=ODE45(fnc,a,b,h,x0,FTol,MaxStps);
println(odeout);
}
/*
S:\ode45>oxl exode45

Ox version 2.10 (Windows) (C) J.A. Doornik, 1994-99
This version may be used for academic research and teaching only

      0.00000      0.00000      0.00000      0.33206
      0.50000     0.041493      0.16589      0.33091
       1.0000      0.16557      0.32978      0.32301
       1.5000      0.37014      0.48679      0.30258
       2.0000      0.65003      0.62977      0.26675
       2.5000      0.99632      0.75126      0.21741
       3.0000       1.3968      0.84605      0.16136
       3.5000       1.8377      0.91304      0.10777
       3.7500       2.0691      0.93701     0.084428
       4.0000       2.3058      0.95552     0.064233
       4.2500       2.5465      0.96941     0.047432
       4.5000       2.7901      0.97952     0.033980
       4.7500       3.0360      0.98666     0.023610
       5.0000       3.2833      0.99155     0.015906
       5.2500       3.5316      0.99479     0.010389
       5.5000       3.7806      0.99688    0.0065782
       5.7500       4.0300      0.99819    0.0040374
       6.0000       4.2796      0.99898    0.0024018
       6.2500       4.5294      0.99944    0.0013849
       6.5000       4.7793      0.99970   0.00077394
       6.7500       5.0293      0.99985   0.00041921
       7.0000       5.2793      0.99992   0.00022007
       7.2500       5.5292      0.99997   0.00011197
       7.5000       5.7792      0.99999  5.5217e-005
       7.7500       6.0292      0.99999  2.6389e-005
       8.0000       6.2792       1.0000  1.2223e-005
       8.2500       6.5292       1.0000  5.4866e-006
       8.7500       7.0292       1.0000  9.1908e-007
       9.2500       7.5292       1.0000  1.2695e-007
       9.7500       8.0292       1.0000  1.3772e-008
       10.000       8.2792       1.0000  4.9579e-009
*/

