#include <oxstd.h>

FZero(const Fcn, const x,...){
//  x0=FZERO(F,X) finds a zero of f(x).  F is a scalar function of
//       a scalar x, and the value supplied for x is a starting guess.
//
//	An optional third argument sets the relative tolerance for convergence.
//      The algorithm is the widely used Dekker-Brent algorithm.
//      Programmed by N. Shamsundar, University of Houston, 1999.

decl a,b,c,d,e,dx,fa,fb,fc,i,m,args=va_arglist(),tol,toler,s,p,q,r;

if(sizeof(args)==0)tol=1.2e-13; else tol=args[0];
if (sizer(x) > 1 || sizec(x) > 1 || any(isdotinf(x))){
   println("Second argument must be a finite scalar.");
   return 0;
   }

dx=x != 0 ? dx = x*0.05 : 0.05;
a = x - dx;  fa = Fcn(a);
b = x + dx;  fb = Fcn(b);

// Find point where F(x) changes sign.

while (fa > 0 == fb > 0){
   dx = 2*dx;
   a = x - dx;  fa = Fcn(a);
   if (fa > 0 != fb > 0)break;
   b = x + dx;  fb = Fcn(b);
   }

fc = fb;
while (fb != 0){
   // Arrange results such that b is the best roott so far,
   // a is the previous value of b, and F(c)F(b) < 0.
   if (fb > 0 == fc > 0){
      c = a;  fc = fa;
      d = b - a;  e = d;
   }
   if (fabs(fc) < fabs(fb)){
      a = b;    b = c;    c = a;
      fa = fb;  fb = fc;  fc = fa;
      }

   // Convergence test
   m = 0.5*(c - b);
   toler = 2.0*tol*max(fabs(b),1.0);
   if (fabs(m) <= toler || fb == 0.0)break;

   // Choose bisection or interpolation
   if (fabs(e) < toler || fabs(fa) <= fabs(fb)){
   // Bisection
      d = m;  e = m;
      }else{
   // Interpolation
      s = fb/fa;
      if (a == c){
      // Linear interpolation
         p = 2.0*m*s;
         q = 1.0 - s;
	}else{
      // Inverse quadratic interpolation
         q = fa/fc;
         r = fb/fc;
         p = s*(2.0*m*q*(q - r) - (b - a)*(r - 1.0));
         q = (q - 1.0)*(r - 1.0)*(s - 1.0);
	}
      if (p > 0) q = -q; else p = -p;
      // Is interpolated point acceptable
      if (2.0*p < 3.0*m*q - fabs(toler*q) * p < fabs(0.5*e*q)){
         e = d;  d = p/q;
         } else {d = m;  e = m;}
     }
   // End Interpolation

   // Select next point
   a = b;
   fa = fb;
   if (fabs(d) > toler) b = b + d;
   else {if (b > c) b-= toler; 
        else b += toler;
        }
   fb = Fcn(b);
	}
return b;
}
