#include <oxstd.h>
#include <oxfloat.h>

ODE45(const fnc,const a,const b,const h0,const x0,const FTol,const Maxstps){
//
// u=ODE45(fnc,a,b,h,x0,FTol,MaxStps);
// Runge-Kutta-Fehlberg integration of the initial value problem
//
//              dx/dt=F(t,x),   x=<x1(t),x2(t),...>,
//              x(a)=x0, a < t < b
//
//     for a system of 1-order Ordinary differential equations
//     with adaptive step-size control.
// Programmed by N. Shamsundar, University of Houston, 10/1999.
//
// ODEfile : dx=fnc(t,x), with dx and x column vectors, provides
//     the system of ordinary differential equations to be solved,
//     dx_i=F_i(t,x)
//
// Integrate from t=a to t=b, with initial condition x(a)=x0,
// initial step-size h0.
// FTol is column vector of tolerances on x
// MaxStps is maximum number of steps from a to b
//
// The output matrix u has t in first column,x in the other columns.
//
decl h,k,x,m,n,iflag,d,fa,fab,fc,fd,t,y,s,i,j,F,dx,e,tout,xout;
fa=<16/135,0,6656/12825,28561/56430,-9/50,2/55>';
fab=<1/360,0,-128/4275,-2197/75240,1/50,2/55>';
fc=<0,1/4,3/8,12/13,1,1/2>';
fd=<0,0,0,0,0,0; 
    1/4,0,0,0,0,0;
    3/32,9/32,0,0,0,0; 
    1932/2197,-7200/2197,7296/2197,0,0,0;
    439/216,-8,3680/513,-845/4104,0,0;
    -8/27,2,-3544/2565,1859/4104,-11/40,0>;

t=a; n=sizer(x0); m=sizec(x0); h=h0; x=x0;
if(m!=1){
	println("ODE45: Initial values must be a column vector");
	return 0;
	}
if(sizer(FTol) != n){
	println("ODE45: FTol must be same size as y");
	return 0;
	}
if(sizer(fnc(t,x0)) !=n){
	println("ODE45: ODE function must return column vector");
	return 0;
	}
F=zeros(n,6);
iflag=FALSE; tout=a; xout=x0';
for(k=0; k<Maxstps; k++){
	d=b-t; if(fabs(d) <= fabs(h)){iflag=TRUE; h=d;}
	s=t; y=x;
	for(i=0; i<6; i++)
 	   F[][i]=h*fnc(t+h*fc[i],x+F*fd[i][]');
	x+=F*fa; e=F*fab;
	t+=h;
	if(iflag){
		tout=tout | t;
		xout=xout | x';
		return tout~xout;
		}
	if(fabs(e) >= FTol){
		t=s; h/=2; x=y; k--;
		}
	else{
		tout=tout | t; xout=xout | x';
		if(fabs(e) < FTol/128)h+=h;
		}
	}
println("ODE45 did not complete integration in ",Maxstps," steps");
return 0;
}
