#include <oxstd.h>
#include <packages/oxmpi/oxmpi.h>


f(const a)
{
    return (4.0 ./ (1.0 + a*a));
}

main()
{
    decl n, myid, numprocs, i;
    decl PI25DT = 3.141592653589793238462643;
    decl mypi, pi, h, sum, x;
    decl startwtime, endwtime;
    decl procname;


    OxMPI_Init();
    numprocs = OxMPI_Comm_size();
    myid = OxMPI_Comm_rank();
    procname = OxMPI_Get_processor_name();
    
    println("Process ", myid, " of ", numprocs,
        " on ", procname);
    
    if (myid == 0)
    {   n = 100000;
        startwtime = OxMPI_Wtime();
    }
    OxMPI_Bcast(&n, 0);
    println("id: ", myid, " n=", n);

    h = 1.0 / n;
    sum = 0.0;

    for (i = myid + 1; i <= n; i += numprocs)
    {
        x = h * (i - 0.5);
        sum += f(x);
    }
    mypi = h * double(sum);
    println("id: ", myid, " sum=", sum);

    pi = OxMPI_Reduce(mypi, OxMPI_SUM, 0);
    
    
    if (myid == 0)
    {
        println("pi=", "%.16f", pi, ", Error=",
            "%.16f", fabs(pi - PI25DT));
        endwtime = OxMPI_Wtime();
        println("wall clock time = ",
            endwtime - startwtime);        
    }    
    OxMPI_Finalize();
}