#ifndef LOOP_INCLUDED
#define LOOP_INCLUDED

class Loop
{
	static Run(const fnRun, const cRep);
	static RunEx(const fnInit, const fnRun, const cRep, const fnProcess, ...);
	static doLoopAsManager(const cWorkers, const cRep, const fnProcess, const acReject);
	static doLoopAsWorker(const iManager, const fnRun, const fnProcess, const acReject);
	static doLoop(const cRep, const fnRun, const fnProcess, const acReject,
		const bBlockSeed);
	static getResultSize(const mAdd);
	static storeResult(const amResult, mAdd, const iRep, const cRep, const fnProcess);
	static storeResultsBlock(const amResult, mAdd, const iRep, const cRepTot);
	static checkResult(const amResult, const cRep, const cRepTot);

	static decl sm_fWorkerOutput;
	static decl sm_bUseIterSeed = 1;
	static decl sm_cWorkers;
	static decl sm_iManager = -1;
	static decl sm_cBlockSize;
	static decl sm_fInitialized, sm_iVerbose;
	
	static UseIterSeed(const bUse);		
	static UseRanSeed(const bUse);		// deprecated, use UseIterSeed instead
	static SetWorkerOutput(const fSet);
	static IsManager();
	static IsWorker();
	static Init();
	static SetVerbose(const iVerbose);
	static SetBlockSize(const iBlockSize);
	static Timer();
};

#endif /* LOOP_INCLUDED */

