#include <oxstd.oxh>

// not really necessary: the OxMPI version can also run serially
#ifdef OX_MPI
  #import <packages/oxmpi/simulator>             // MPI version
#else
  #import <simulator>        	  // import default simulation class
#endif

#import <packages/oxmpi/loop>   // to experiment with block size

NormTest1(const vX)
{
    decl xs, ct, skew, kurt, test;

    ct = rows(vX);                            // sample size
    xs = standardize(vX);

    skew = sumc(xs .^ 3) / ct;            // sample skewness
    kurt = sumc(xs .^ 4) / ct;            // sample kurtosis
    test = sqr(skew) * ct / 6 + sqr(kurt - 3) * ct / 24;

return test | tailchi(test, 2);//[0][0]:test,[1][0]: p-value
}

///////////////////////// SimNormal : Simulator
class SimNormal : Simulator// inherit from simulation class
{
    decl m_time;           // test statistic, timer
    SimNormal(const cT, const cM, const vPvals);//constructr
    ~SimNormal();                               //destructor
    Generate(const iRep, const cT, const mxT);// replication
};
SimNormal::SimNormal(const cT, const cM, const vPvals)
{
    Simulator(cT, cT, cM, TRUE, -1, vPvals, 0);
    SetTestNames({"normal asymp"});
    m_time = Loop::Timer();
}
SimNormal::~SimNormal()
{
    println("SimNormal package used for: ",
		Loop::Timer() - m_time, " secs.");
}
SimNormal::Generate(const iRep, const cT, const mxT)
{
	decl x = rann(cT, 1);
    decl test = NormTest1(x);

return {1, <>, test[1], test[0]};                  // 1 indicates success, 0 failure
}
////////////////////////////////////////////////////////////
main()
{
	decl args = arglist(), cm = 1000000, cb = -1;
	if (sizeof(args) > 1)
		sscan(args[1], "%d", &cm);
	if (sizeof(args) > 2)
		sscan(args[2], "%d", &cb);
	
	Loop::SetVerbose(1);
//	Loop::SetBlockSize(cb);

	decl exp = new SimNormal(250, cm, <.2,.1,.05,.01>);
    exp.Simulate();                        // do simulations
    delete exp;                             // remove object
}
