#include <oxstd.h>				   // include Ox standard library
#include <oxdraw.h>				    // include Ox drawing library

NormTest1(const vX)                 // function with one argument
{
    decl xs, ct, skew, kurt, test;  // variables must be declared

    ct = rows(vX);                                 // sample size
    xs = standardize(vX);

    skew = sumc(xs .^ 3) / ct;                 // sample skewness
    kurt = sumc(xs .^ 4) / ct;                 // sample kurtosis
    test = sqr(skew) * ct / 6 + sqr(kurt - 3) * ct / 24;

return test | tailchi(test, 2);  // [0][0]: test, [1][0]: p-value
}
SimNormTest1(const cT, const cM, const vPvals)
{
    decl eps, i, test, tests, reject;
    
    tests = new matrix[1][cM]; // create new matrix (set to zero)
    reject = zeros(1, columns(vPvals));//also new matrix of zeros
    
    for (i = 0; i < cM; ++i)    // loop syntax is like C,C++,Java
    {
        eps = rann(cT, 1); // T x 1 vector of std.normal drawings
        test = NormTest1(eps);          // call the test function
        tests[i] = test[0];// stores actual outcomes for plotting
        reject += test[1] .<= vPvals;   // update rejection count
    }
    reject /= cM;                       // translate to frequency
    return {tests, reject};                 // return both values
}
main()
{   
    decl ct = 50, tests, reject;
    decl pvals = <0.5,.2,.1,.05,.01>;  // <..> is matrix constant
    
    decl time = timer();        // start timer and run experiment
    [tests, reject] = SimNormTest1(ct, 10000, pvals);
    println("Simulation time: ", timespan(time));
    
    DrawDensity( // draw the non-parametrically estimated density
        0, tests,
        sprint("Empirical distribution: normality test, T=", ct),
        FALSE, TRUE);
    DrawXMatrix(                // add the reference distribution
        0, denschi(range(1,100)/10, 2), "$\chi^2(2)$",
        range(1,100)/10, "", 0, 3);
    DrawAdjust(ADJ_AREA_X, 0, 0, 15);// cut fat tails from X-axis
    ShowDrawWindow();

    println(        // print selected quantiles (data is in rows)
        "Simulation of normality test",
        "%r", {"significance", "critical values", "rejection"},
        "%8.3f",
        pvals | quantiler(tests, 1 - pvals) | reject);
}
