#ifndef OXMPI_CODES_INCLUDED
#define OXMPI_CODES_INCLUDED

/* this header file is shared between Ox code and C code, so keeping it as .h */

enum
{	/* Collective operations */
	OxMPI_MAX		 = 10000,
	OxMPI_MIN,
	OxMPI_SUM,
	OxMPI_PROD,
	OxMPI_LAND,
	OxMPI_BAND,
	OxMPI_LOR,
	OxMPI_BOR,
	OxMPI_LXOR,
	OxMPI_BXOR,
	OxMPI_MINLOC,
	OxMPI_MAXLOC,
	OxMPI_REPLACE,
	OxMPI_OP_NULL	 = -1
};
enum
{
	OxMPI_COMM_WORLD =  91,	  /* Communicators */
	OxMPI_COMM_SELF  =  92,
	OxMPI_GROUP_EMPTY=  90,	 		 /* Groups */
	OxMPI_PROC_NULL  = -10,
	OxMPI_ANY_SOURCE =  -2,
	OxMPI_ROOT       =  -3,
	OxMPI_ANY_TAG    =  -1,
	OxMPI_UNDEFINED  = -32766
};
enum
{	/* error codes, OXMPI_ERR_OTHER is used for all other error codes */
	OxMPI_SUCCESS    =	 0,
	OxMPI_ERR_TYPE   =   3,
	OxMPI_ERR_COMM   =   5,
	OxMPI_ERR_RANK   =	 6,
	OxMPI_ERR_ROOT   =	 7,
	OxMPI_ERR_GROUP   =	 8,
	OxMPI_ERR_OP      =	 9,
	OxMPI_ERR_OTHER  =  15
};	

#endif /* OXMPI_CODES_INCLUDED */
