#include <oxstd.oxh>
#import <packages/oxmpi/loop>

static decl s_vBeta_dgp, s_cT;

Run_i(const i)
{
	decl vcoefs;
	decl X = rann(s_cT, sizerc(s_vBeta_dgp));
	decl y = X * s_vBeta_dgp + rann(s_cT, 1);

	olsc(y, X, &vcoefs);		 	// do the regression

	return vcoefs;
}

Run(cRep, vBeta, dRho_dgp, cT)
{
	decl beta_dgp = vec(vBeta);	 		// DGP parameters
	decl cn = sizerc(beta_dgp);
	decl asx = new array[cn], k;

	foreach (decl asx_k in asx[k])		// asx_k not used
	{									// create names
		asx[k] = sprint("x", k + 1);
	}

	ranseed(-1);
	
	decl i, mcoefs = zeros(cn, cRep), time = timer();
	decl creject;

	s_vBeta_dgp = beta_dgp;
	s_cT = cT;
	
	mcoefs = Loop::RunEx(0, Run_i, cRep, 0, &creject);

	println("%r", asx, beta_dgp ~ meanr(mcoefs));
	println("M=", cRep, " overall time:", timespan(time));
}
main()
{
	decl cm = 1000000;

	Run(cm, zeros(1, 5), 0.9, 100);
}