/*--------------------------------------------------------------------------
 * simulator.ox - OxMPI plug-in replacement for Simulator class
 *
 *       (C) Jurgen Doornik 2012
 *--------------------------------------------------------------------------*/

#include <oxstd.oxh>
#include <oxfloat.oxh>
#import <simulatorbase>
#import <packages/oxmpi/loop>
#include "simulator.oxh"

Simulator::Simulator(const mT, const mxT, const cRep, const fCommon,
	const dSeed, const mPvalue,const mTrueParam)
{
	SimulatorBase(mT, mxT, cRep, fCommon, dSeed, mPvalue,mTrueParam); 
}

Simulator::doReplicationGeneration(const iItno)
{
	decl aret = Generate(iItno, m_iT, m_mxT);
	if (sizerc(aret) == 0 || aret[0] == 0)
		return <>;

	return aret[1 : ];
}

Simulator::Simulate_t(const cT)
{
	decl ct, i, t, citer = m_cRep, creject, amresult;

	m_iT = cT;

	amresult = Loop::RunEx(0, doReplicationGeneration, citer,
		0, &creject);

	citer = storeAllReplications(amresult);
	
	m_bUsedIterSeed = TRUE;
	
	return {citer, creject, citer};
}
