#include <oxstd.oxh>
#include <oxdraw.oxh>

main()
{   // variables must be declared
    decl ct = 1000, cn = 2, cm = 10000, eps, sum, i, tr, fac;
    
    tr = new matrix[1][cm];               // create new matrix
    decl time = timer();
    for (i = 0; i < cm; ++i)
    {
        eps = rann(ct, cn);               // T x n std.normal
        sum = lag0(cumulate(eps), 1);     // lagged sum
        fac = eps'sum;
        // compute the trace test
        tr[i] = trace(fac * invertsym(sum'sum) * fac);
    }
    println("Simulation time: ", timespan(time));
    
    // draw the non-parametrically estimated density 
    DrawDensity(0, tr, "trace", FALSE, TRUE);
    ShowDrawWindow();
    // print selected quantiles (data is in rows)
    println( quantiler(tr, <0.50,0.8,0.90,0.95,0.99>) );
}
