#include <oxstd.oxh>
#include "tracetest.oxh"

TraceTest::TraceTest(const mT, const cN, const cM)
{
    m_cN = cN;
    Simulator(mT, max(mT), cM, TRUE, -1, <0.2,0.1,0.05>, <>);
    SetTestNames("Trace");
    m_time = timer();
}
TraceTest::~TraceTest()
{
    println("TraceTest object used for: ", timespan(m_time));
}
TraceTest::RanTest(const cT, const cN)
{
    decl eps, p, sum, fac, ev;
    
    eps = rann(cT, cN);                  // T x n std.normal
    p = invert(choleski(eps'eps / cT));         // E'E = PP'
    eps *= p';          // give eps unit variance: E'E = T*I
    sum = lag0(cumulate(eps), 1);              // lagged sum
    fac = eps'sum;
    eigensym(fac * invertsym(sum'sum) * fac', &ev);
    return -cT * sumr(log(1 - ev / cT));
}
TraceTest::Generate(const iRep, const cT, const mxT)
{
    return {1, <>, <>, RanTest(cT, m_cN) };
}
