
#include <oxstd.h>
#include <oxdraw.h>
#include "str2.h"
 

STR2::PrintVCMatrix(const value)
{
	bPrintVarCovarMatrix=value;	
}

STR2::RemoveArrayElement(const index,const vXvar)
{
	decl vX;  
	if(index==0) vX=vXvar[1:];
	else if(index==columns(vXvar)-1) vX=vXvar[0:index-1];
	else vX=vXvar[0:index-1]~vXvar[index+1:];
	return vX;
}

STR2::Remove(const index,const mXvar)
{
	decl mX;  
	if(index==0) mX=mXvar[][1:];
	else if(index==columns(mXvar)-1) mX=mXvar[][0:index-1];
	else mX=mXvar[][0:index-1]~mXvar[][index+1:];
	return mX;
}

STR2::LongRunParameters2(const vBeta,const mVarCovar)
{
	decl iLagIndex,vLagEndo,asLagNames,sYname,sel,c1,c2,iLengthLin,iLengthNlin,sd,
	asNames,beta2,var2,bLagLinOnly,indexConstant,test,iLagIndexLevel,iLagIndexLevelNlin,
	bLagLevelInLin,bLagLevelInNonLin,sLagLevel,BetaLevelLin,BetaLevelNlin,m;
	bLagLevelInLin=bLagLevelInNonLin=FALSE;
	iLengthLin=columns(m_mX_linear);iLengthNlin=columns(m_mX_nonlinear);iLagIndexLevel=-1;
	vLagEndo=lag0(vYvar,1);iLagIndex=-1;bLagLinOnly=FALSE;
	for(c1=0;c1<iLengthLin;++c1) //Lag level in linear part ?
	{
		decl test;
		test=(lag0(m_mX_linear[][c1],-1)-m_mX_linear[][c1]);
		if(vYvar[0:rows(m_mX_linear)-2][]==test[0:rows(m_mX_linear)-2][])
		{
			println("Lagged endogenous level :",m_asNamesLinearPart[c1]);iLagIndexLevel=c1;
			bLagLevelInLin=TRUE;sLagLevel=m_asNamesLinearPart[c1];
			BetaLevelLin=vBeta[2+iLagIndexLevel];
			println("BetaLevelLin:",BetaLevelLin);
		}
	}
	for(c1=0;c1<iLengthNlin;++c1){
		decl test;
		test=lag0(m_mX_nonlinear[][c1],-1)-m_mX_nonlinear[][c1];
		if(vYvar[0:rows(m_mX_nonlinear)-2][]==test[0:rows(m_mX_nonlinear)-2][]){
			println("Lagged endogenous level nlin:",m_asNamesNonLinearPart[c1]," c1: ",c1);
			iLagIndexLevelNlin=c1;bLagLevelInNonLin=TRUE;
			sLagLevel=m_asNamesNonLinearPart[c1];
			BetaLevelNlin=vBeta[2+iLagIndexLevelNlin+iLengthLin];
			println("Beta nlin:",BetaLevelNlin);
		}
	}
	if(bLagLevelInLin && !bLagLevelInNonLin)		// Lagged endogenous level only in linear part
	{
		decl var,covar,beta1,beta2,names,c2,ashelp;
		names=m_asNamesLinearPart|m_asNamesNonLinearPart;
		for(c1=0;c1<iLengthLin;++c1){
			beta1=vBeta[2+c1];
			covar=mVarCovar[2+iLagIndexLevel][2+c1];
			println(mVarCovar[2+c1][2+c1],mVarCovar[2+iLagIndexLevel][2+iLagIndexLevel],covar);
			var=(1/BetaLevelLin)^2*mVarCovar[2+c1][2+c1]+(beta1/BetaLevelLin^2)^2*mVarCovar[2+iLagIndexLevel][2+iLagIndexLevel]+2*(1/BetaLevelLin)*(beta1/BetaLevelLin^2)*covar;
			println(names[c1],"  Longrunpar=",-beta1/BetaLevelLin,"  t-values=",(-beta1/BetaLevelLin)/sqrt(var));
		}
		for(c1=0;c1<iLengthNlin;++c1){
			decl beta1,beta2,covar1,covar2,LinIndex,var1,var2;
			beta1=vBeta[2+c1+iLengthLin];  // Non-linear part
			LinIndex=strifind(m_asNamesLinearPart,m_asNamesNonLinearPart[c1]);
			if(LinIndex==-1){	 // Variabels have no linear part
//				beta2=0;
				covar=mVarCovar[2+iLagIndexLevel][2+c1+iLengthLin];
//				println(mVarCovar[2+c1+iLengthLin][2+c1+iLengthLin],mVarCovar[2+iLagIndexLevel][2+iLagIndexLevel],covar);
				var=(1/BetaLevelLin)^2*mVarCovar[2+c1+iLengthLin][2+c1+iLengthLin]+(beta1/BetaLevelLin^2)^2*mVarCovar[2+iLagIndexLevel][2+iLagIndexLevel]+2*(1/BetaLevelLin)*(beta1/BetaLevelLin^2)*covar;
				println(m_asNamesNonLinearPart[c1],"  Longrunpar=",-beta1/BetaLevelLin,"  t-values=",(-beta1/BetaLevelLin)/sqrt(var));
			}
			else { //Variables in both linear and nonlinear part
				decl covar12,covar23,covar13,var3,b1,b2,b3;
				beta2=vBeta[2+LinIndex];
				b1=-(1/BetaLevelLin); //Non-linear part
				b2=-(1/BetaLevelLin); //Non-linear part
//				b2=(1/vBeta[2+LinIndex])^2;//Lineear part
				b3=-(beta1+beta2)/(BetaLevelLin^2);
				var1=mVarCovar[2+LinIndex][2+LinIndex];
				var2=mVarCovar[2+c1+iLengthLin][2+c1+iLengthLin];
				var3=mVarCovar[2+iLagIndexLevel][2+iLagIndexLevel];
				covar12=mVarCovar[2+LinIndex][2+c1+iLengthLin];
				covar13=mVarCovar[2+LinIndex][2+iLagIndexLevel];
				covar23=mVarCovar[2+c1+iLengthLin][2+iLagIndexLevel];
			    var=b1^2*var1+b2^2*var2+b3^2*var3+2*b1*b2*covar12+2*b2*b3*covar23+2*b1*b3*covar13;
//				println(beta1,beta2,BetaLevelLin);
//				println(var1,var2,var3,covar12,covar13,covar23);
				println(m_asNamesNonLinearPart[c1]," Long:",-(beta1+beta2)/BetaLevelLin," t-values:",-(beta1+beta2)/BetaLevelLin/sqrt(var));
			}//end else	
		}
	}
	else  
	{
		decl beta,c1,beta1,beta2,beta3,beta4,covar1,covar2,covar3,covar4,
		covar5,covar6,var1,var2,var3,var4,var,b1,b2,b3,b4,names,c2,ashelp;
		if(bLagLevelInLin)
		for(c1=0;c1<iLengthLin;++c1){
			decl var,covar,beta1;
			beta1=vBeta[2+c1];
			covar=mVarCovar[2+iLagIndexLevelNlin][2+c1];
			var=(1/BetaLevelLin)^2*mVarCovar[2+c1][2+c1]+(beta1/BetaLevelLin^2)^2*mVarCovar[2+iLagIndexLevelNlin][2+iLagIndexLevelNlin]+2*(1/BetaLevelLin)*(beta1/BetaLevelLin^2)*covar;
			println(mVarCovar[2+c1][2+c1],mVarCovar[2+iLagIndexLevelNlin][2+iLagIndexLevelNlin],covar);
			println(m_asNamesLinearPart[c1]," ",beta1,"  Longrunpar=",-beta1/BetaLevelLin,"  t-values=",(-beta1/BetaLevelLin)/sqrt(var));
		}
	 if(bLagLevelInNonLin) {
		beta3=BetaLevelLin;
		beta4=BetaLevelNlin;
		var3=mVarCovar[2+iLagIndexLevelNlin][2+iLagIndexLevelNlin];
		var4=mVarCovar[2+iLagIndexLevelNlin+iLengthLin][2+iLagIndexLevelNlin+iLengthLin];
		covar6=2*mVarCovar[2+iLagIndexLevelNlin][2+iLagIndexLevelNlin+iLengthLin];
		for(c1=0;c1<iLengthNlin;++c1)
		{
			beta1=vBeta[2+c1];
			beta2=vBeta[2+c1+iLengthLin];
			b1=(1/(beta3+beta4));
			b2=b1;
			b3=(-beta3*(beta1+beta2)/(beta3+beta4)^2);
			b4=(-beta4*(beta1+beta2)/(beta3+beta4)^2);
			covar1=2*mVarCovar[2+c1][2+c1+iLengthLin];
			covar2=2*mVarCovar[2+c1][2+iLagIndexLevelNlin];
			covar3=2*mVarCovar[2+c1][2+iLagIndexLevelNlin+iLengthLin];
			covar4=2*mVarCovar[2+c1+iLengthLin][2+iLagIndexLevelNlin];
			covar5=2*mVarCovar[2+c1+iLengthLin][2+iLagIndexLevelNlin+iLengthLin];

			var1=mVarCovar[2+c1][2+c1];
			var2=mVarCovar[2+c1+iLengthLin][2+c1+iLengthLin];
			println(m_asNamesNonLinearPart[c1]," ",vBeta[2+c1]," ",vBeta[2+c1+iLengthLin]);
			println(var1,var2,var3,var4,vBeta[2+c1],vBeta[2+c1+iLengthLin],BetaLevelNlin,BetaLevelLin);
			println(covar1,covar2,covar3,covar4,covar5,covar6);

			beta=(vBeta[2+c1]+vBeta[2+c1+iLengthLin])/(BetaLevelNlin+BetaLevelLin);
			if(strifind(asZeroRestrictionsNames,sLagLevel)!=-1) b3=var3=beta3=covar2=covar4=covar6=0;
//			if(bLagLevelInLin)b2=beta2=var2=covar1=covar4=covar5=0;
			var=b1^2*var1+b2^2*var2+b3^2*var3*b4^2*var4+2*b1*b2*covar1+2*b1*b3*covar2+2*b1*b4*covar3+2*b2*b3*covar4+2*b2*b4*covar5+2*b3*b4*covar6;
			println("Longrunpar=",-beta,"  t-values=",-beta/sqrt(var));
		}
	}	
			
	}
}

STR2::GetPackageVersion()
{
	return "0.86 beta";
}	

STR2::GetPackageName()
{
	return "STR2";
}

STR2::GetData()
{
    ClearModel();

    if (m_iT1sel < 0)
        SetSample(-1, 1, -1, 1);

    m_iT1est = m_iT1sel;  m_iT2est = m_iT2sel;
    m_cT = m_iT2est - m_iT1est + 1;


//	vYvar=trvar=new array[0];
	trvar=GetGroup(TR_VAR); trvar=trvar[][0];
//	println("trvar",trvar);
	trvar2=GetGroup(TR_VAR2);
	if (trvar2!=<> && m_iMethod==LSTR1_2) trvar2=trvar2[][0];
  	vYvar=GetGroup(Y_VARS); vYvar=vYvar[][0];
  	m_mX_nonlinear=GetGroup(X_NONLIN);
	m_mX_nonlinear2=GetGroup(X_NONLIN2);
	bTwoTrVar=columns(m_mX_nonlinear2)>0;
	if (!bTwoTrVar && m_iMethod==LSTR1_2)
	{
		println("ERROR:No variable chosen as 2nd transition variable"); exit(1);
	}	
  	m_mX_linearOnly=GetGroup(X_LIN);
//	if(intersection(m_mX_linearOnly,m_mX_nonlinear~m_mX_nonlinear2)!=<>)
//	{
//		println("ERROR: Linear and non-linear parts have common elements");exit(1);
//	}	
	if(m_iMethod==LSTR1_2) m_mX_linear=m_mX_nonlinear~m_mX_nonlinear2~m_mX_linearOnly;
	else m_mX_linear=m_mX_nonlinear~m_mX_linearOnly;	  // Assuming all variables entering lin and non-lin. Zero-restrictions dealt with later
	ZeroRestrictions=GetGroup(NULL);
	bZeroRestrictions=columns(GetGroup(NULL))>0;
	if (columns(ZeroRestrictions)) {println("Zero-restriction(s) imposed on linear part of non-lin variable(s)");
				println("Restrictions: ", columns(ZeroRestrictions));}
	if (bTwoTrVar && m_iMethod==LSTR1_2) println("Two transition-variables");	
	GetGroupNames(X_NONLIN,&m_asNamesNonLinearPart);
	GetGroupNames(X_NONLIN2,&m_asNamesNonLinearPart2);
	GetGroupNames(X_LIN,&m_asNamesLinearPartOnly);
  	GetGroupNames(TR_VAR,&sTrVarName);
	GetGroupNames(TR_VAR2,&sTrVarName2);
	GetGroupNames(NULL,&asZeroRestrictionsNames);
	if(m_iMethod==LSTR1_2) m_asNamesLinearPart=m_asNamesNonLinearPart|m_asNamesNonLinearPart2|m_asNamesLinearPartOnly;
	else m_asNamesLinearPart=m_asNamesNonLinearPart|m_asNamesLinearPartOnly;
	if (bTwoTrVar && m_iMethod==LSTR1_2 && intersection(m_mX_nonlinear,m_mX_nonlinear2)!=<>)
	{ //If the two non-linear parts have common elements one instance of these variables must be removed from the linear part
		decl count,asHelp,mHelp;
		asHelp=m_asNamesNonLinearPart2;
		mHelp=m_mX_nonlinear2;
		for(count=0;count<columns(m_mX_nonlinear);++count)
			{
				decl Index;
				Index=strifind(asHelp,m_asNamesNonLinearPart[count]);
				if(Index!=-1)
				{
					asHelp=RemoveArrayElement(Index,asHelp);
					mHelp=Remove(Index,mHelp);
				}
			}			
	m_asNamesLinearPart=m_asNamesNonLinearPart|asHelp|m_asNamesLinearPartOnly;	
	m_mX_linear=m_mX_nonlinear~mHelp~m_mX_linearOnly;
	}
	if (columns(ZeroRestrictions)>0)  //Imposes the zero-restrictions
	{
		decl count,Index;
		for(count=0;count<columns(ZeroRestrictions);++count)
		{
			Index=strifind(m_asNamesLinearPart,asZeroRestrictionsNames[count]);
			if(Index==-1) {println("ERROR: Please use zero-restrictions on non-linear variables only");exit(1);}
			m_asNamesLinearPart=RemoveArrayElement(Index,m_asNamesLinearPart);
			m_mX_linear=Remove(Index,m_mX_linear);
		}
	}
	if(m_iMethod==LSTR1_2) m_asAllNames=m_asNamesLinearPart|m_asNamesNonLinearPart|m_asNamesNonLinearPart2;
	else m_asAllNames=m_asNamesLinearPart|m_asNamesNonLinearPart;
	if (m_iMethod==LSTR1_2) m_asSTRnames={"GAMMA1","C1","GAMMA2","C2"};
	else if (m_iMethod==LSTR2) m_asSTRnames={"GAMMA","C1","C2"};
	else m_asSTRnames={"GAMMA","C1"};
}

STR2::SetIstd()
{
	if (m_iMethod==LSTR1_2){
		if (TrErTrend) istd = 1 / meanc(trvar);
		else istd = 1 / sqrt(varc(trvar));
		if (TrErTrend2)istd2=1/meanc(trvar2);
		else istd2=1/sqrt(varc(trvar2));}

	else {
		if (TrErTrend) istd = 1 / meanc(trvar);
		else istd = 1 / sqrt(varc(trvar));}
}	

STR2::Gradient(const x,const tf,const tf2)
{
	decl gv,gv1,c3,h,c4;
	/* Give the gradient for the misspecification tests */
	if (m_iMethod==LSTR1_2) h=4; else h=2;
	if (m_iMethod==LSTR2) h=3;
	gv1=zeros(rows(vYvar),h);
	gv1[][0]=(1 ./(exp(-0.5*x[0]*istd*(trvar-x[1]))+exp(0.5*x[0]*istd*(trvar-x[1]))).^2).*(trvar-x[1]).*c;
	gv1[][1]=(1 ./(exp(-0.5*x[0]*istd*(trvar-x[1]))+exp(0.5*x[0]*istd*(trvar-x[1]))).^2).*c*x[0]*istd;
	if (m_iMethod==LSTR2)	 //Tvilsomt
		gv1[][2]=(1 ./(exp(-0.5*x[0]*istd*(trvar-x[2]))+exp(0.5*x[0]*istd*(trvar-x[2]))).^2).*c*x[0]*istd;
	if (m_iMethod==LSTR1_2)
	{
		gv1[][2]=(1 ./(exp(-0.5*x[2]*istd2*(trvar2-x[3]))+exp(0.5*x[2]*istd2*(trvar2-x[3]))).^2).*(trvar2-x[3]).*c2;
		gv1[][3]=(1 ./(exp(-0.5*x[2]*istd2*(trvar2-x[3]))+exp(0.5*x[2]*istd2*(trvar2-x[3]))).^2).*c*x[2]*istd2;
	};	
	
	c3=tf.*m_mX_nonlinear;
	if (m_iMethod==LSTR1_2){ c4=tf2.*m_mX_nonlinear2;gv=gv1~m_mX_linear~c3~c4;}
	else gv=gv1~m_mX_linear~c3;
	return gv;
}

STR2::DoEstimation()
{
  decl x,adfunk,x0,x1,ym,ssy,n,nx,hd,rvar,tf,time,z,aminvhess,mVarCovar,ci,ci2,
  xorg,adf,rsd,ssr,xsd,sbic,aic,r2,tt,nimi,i,t,names,hn,avScore,H,off,off2,count,dummy;
  time=timer();
  if (m_iMethod==LSTR2)x=xorg=init2();else x=xorg=init();
  x=x[][0];xorg=xorg[][0];
  println("\nThe search for starting values took ",(timer()-time)/100," seconds :\n");
  // starting values for hess
  if (num2)
  	aminvhess =	unit(rows(x));
  else
    aminvhess = setdiagonal(zeros(rows(x),rows(x)), -1 ./ x);
	
  x0=MaxBFGS(objektfn,&x,&adfunk,&aminvhess,1);
  print("Returncode from MaxBFGS: ",x0,"\n");
  print(MaxConvergenceMsg(x0),"\n");
  if (num2)
  { x1=Num2Derivative(objektfn,xorg,&H);
  	println("Returncode from Num2Derivative: ",x1);
    aminvhess=-invert(H);
  }
  else
	println("WARNING: stderrs from MaxBFGS");
  ym=meanc(vYvar);
  ssy=(vYvar-ym*1)'(vYvar-ym*1);
  adfunk=-adfunk;
  n = rows(m_mX_linear);
  nx = rows(x);
  hd=sqrt(diagonal(aminvhess));
  hd=hd';
  rvar=adfunk/(n-nx);rsd=sqrt(rvar);ssr=adfunk/n;
  
  r2=1-adfunk/ssy;
  aic=log(ssr)+2*nx/n;
  sbic=log(ssr)+log(n)*(nx/n);
  xsd=sqrt(2)*rsd*hd;
  tt=x./xsd;
  Output(x,xsd,tt,m_asSTRnames,m_asAllNames);
  	println("Initial func value",m_InitialAdfunk);  
    println("SSR/function value  ",adfunk);
	println("Inv std of tr var      ",istd);
	println("SSR/number of obs.     ",ssr);
	println("AIC                    ",aic);
	println("SBIC                   ",sbic);
	println("1000*Residual variance ",1000*rvar);
	println("R-squared              ",r2);
	println("Std error of residuals ",rsd,"\n\n");
  mVarCovar=rvar*aminvhess;
//  LongRunParameters2(x,mVarCovar);
  if(bPrintVarCovarMatrix)PrintVarCovarMatrix(x,mVarCovar); 
  objektfn(x,&dummy,0,0); // Called to set the residuals in optimum
  if (m_iMethod==LSTR1_2) gradient=Gradient(x,m_vTrFunc1,m_vTrFunc2);else gradient=Gradient(x,m_vTrFunc1,0);

}

STR2::PrintVarCovarMatrix(const x,const mVarCovar)
{
  decl ci,ci2;
  for(ci=0;ci<rows(x);++ci)
  	{
		print("\n");
		for(ci2=0;ci2<rows(x);++ci2)
		{
			print(mVarCovar[ci][ci2]);
			print(";");
		}	
	}
	println(" ");
}

STR2::Estimate()
{
  GetData();
  SetIstd();
  if (m_iMethod!=LSTR1_2) PreTest();
  DoEstimation();
  PostTest();
  return 1;
}

STR2::PreTest()
{
	decl laglb,maxlag,lagml,knt,kntmax,ytest1,ytest2,skp,cxvars,I,M,beta;
	I=unit(rows(vYvar));
	M=I-m_mX_linear*invert(m_mX_linear'm_mX_linear)*m_mX_linear';
	beta=invert(m_mX_linear'm_mX_linear)*m_mX_linear'vYvar;
	res_lin=M*vYvar;
//	laglb=8;
//	kntmax=8;
//	knt=1;
//	maxlag=2;
//	if (res_stat)
//	{
//		while (knt<=kntmax)
//		{
//			lagml=knt;
//			gacf1(res_lin,laglb,maxlag,lagml,knt,kntmax);
//			knt=knt+1;
//		};
//		knt=1;
//		while (knt<=laglb)
//		{
//			gresac1(res_lin,m_mX_linear,knt,knt);
//			knt=knt+1;
//		};
//	};

	if (lin_test)
		{
		println("The following variables are entering the non-linear part of the model:" );
		decl varlist,t,t2,varnames,testvar,testnavn;
		t2=0;
		varnames=zeros(1,columns(m_mX_nonlinear));
		
		varlist=zeros(rows(m_mX_nonlinear),columns(m_mX_nonlinear));
//		println("m_asNamesNonLinearPart",m_asNamesNonLinearPart);
		for(t=0;t<columns(m_mX_nonlinear);++t)
			if (meanc(m_mX_nonlinear[][t]) !=1)		  // avoid the constant
			{
				println(m_asNamesNonLinearPart[t]);
				varlist[][t2]=m_mX_nonlinear[][t];
//				println("varnames ",varnames[t2]);
//				println("m_asNamesNonLinearPart[0][t] ",m_asNamesNonLinearPart[t]);
				varnames[t2]=m_asNamesNonLinearPart[t];
				++t2;
			}  
//			println("varnames ",varnames);
		testvar=trvar;testnavn=sTrVarName;
//		if(strifind(m_asNamesLinearPart|m_asNamesNonLinearPart,sTrVarName)!=-1) { //add the constant if trvar does not enter the model
//			decl sConstant;
//			varlist=1~varlist;++t2;} //sConstant={"Constant"};
//			varnames=sConstant~varnames;}
//		println(varnames[0][0]);	
		if (trvar2!=<>){testvar=testvar~trvar2;testnavn=sTrVarName|sTrVarName2;}
		greslix3(m_mX_linear,varlist[][0:t2-1],0,testvar[][],testnavn[],res_lin);
		lin_test=FALSE;
		}
}

STR2::PostTest()
{
	if (addlin && m_iMethod!=LSTR1_2)
	{
		decl varlist,cxlin,t,t2,varnames,testvar,testnavn;;
		t2=0;
		varnames=zeros(1,columns(m_mX_linearOnly));
		varlist=zeros(rows(m_mX_linearOnly),columns(m_mX_linearOnly));
		println("Test for remaining non-linearity");
		println("Variables allowed to enter non-linearly: ");		
		for(t=0;t<columns(m_mX_linearOnly);++t)
			if (meanc(m_mX_linearOnly[][t]) !=1)		  // avoid constant
			if (!(min(m_mX_linearOnly[][t]).==0 && max(m_mX_linearOnly[][t]).==1))	 // avoid dummies
			if (!(min(m_mX_linearOnly[][t]).==-1 && sumc(m_mX_linearOnly[][t]).==0)) // avoid dummies
			{
				println(m_asNamesLinearPartOnly[t]);
				varlist[][t2]=m_mX_linearOnly[][t];
				++t2;
			}
			testvar=trvar;testnavn=sTrVarName;
			if (trvar2!=<>){testvar=testvar~trvar2;testnavn=sTrVarName|sTrVarName2;}
		greslix3(gradient,varlist[][0:t2-1],trvar[][0],testvar[][],testnavn[],res_nlin);
	};
	if (reset)
	{
		decl r,yhat;
		r=2;
		yhat=vYvar-res_nlin;
		while (r<=3)
		{
			greset1(gradient,yhat,r,res_nlin);
			r=r+1;
		};	
	};
	
	if (res_stat)
	{
		decl i,q;
		i=1;
		while (i<=6)
		{
			q=i;
			gresac1(res_nlin,gradient,q,i);
			++i;
		};
	res_stat=FALSE;
	};
	if (draw_func) DrawTrfunc();
	if (draw_res) DrawResiduals();
	if (print_resi) println("Linear and non-linear residuals,hhv",res_lin,res_nlin);
	if (m_iMethod !=LSTR1_2 && (m_mX_nonlinear2!=<> || nlin_index>0))
	{
		decl skp,ytest1,ytest2,cxvars,nlingrad,count,nvars;
		println("******************************************************************");
		println("Tests for parameter constancy");
		println("Coefficients of:");
		if (m_mX_nonlinear2!=<>) println("Linear parameters: ",m_asNamesNonLinearPart2[]);
		skp=1;
		nlingrad=gradient[][columns(m_mX_linear):columns(gradient)-1];
		if (nlin_index>0)
		{
			println("Non-linear parameters: ");
			nvars=nlingrad[][nlin_index[0]-1];
			println(m_asNamesNonLinearPart[nlin_index[0]-1]);
			for(count=1;count<rows(nlin_index);count++) {
				nvars=nvars~nlingrad[][nlin_index[count]-1];
				println(m_asNamesNonLinearPart[nlin_index[count]-1]);
			}
		}	
		if (nlin_index>0 && m_mX_nonlinear2!=<>) ytest1=m_mX_nonlinear2~nvars;
		else if (nlin_index==0 && m_mX_nonlinear2!=<>) ytest1=m_mX_nonlinear2;
		else ytest1=nvars;
		ytest2=<>; 
		gressc1(gradient,ytest1,ytest2,res_nlin,skp);
	}	
}

STR2::Output(const x,const std,const t,const m_asSTRnames,const m_asAllNames)
{
	decl off,i; 
	println("Sample: ",GetSelSample());
  	println("Frequency: ",GetFrequency());
  	println("\nTransition variable: ",sTrVarName[0],"\n");
  	if (m_iMethod==LSTR1_2) println("Transition variable 2: ",sTrVarName2[0],"\n");
	if (m_iMethod==LSTR1_2) off=4; else off=2;
	if (m_iMethod==LSTR2) off=3;
  	print("\nNumber of observations is      ", rows(m_mX_linear),"\n");
    print("Variable name, coeff estimate, std deviation, and t-value\n");
	if (rows(m_asSTRnames)==0){off=0;}		
	if(rows(m_asSTRnames)!=0)
	{
		for (i=0;i<off;++i)
			println("%-14s",m_asSTRnames[i],"%14.4g",x[i],"%14.4g",std[i],"%14.4g",t[i]);
	}
	for (i=0;i<rows(m_asAllNames);++i)
	{
	  if (i==(columns(m_asNamesLinearPart))) println("Non-linear parameters: ",sTrVarName[0]);
	  if (m_iMethod==LSTR1_2 && i==columns(m_asNamesLinearPart)+columns(m_mX_nonlinear-1)) println("Non-linear parameters:2 ",sTrVarName2[0]);
	  println("%-14s",m_asAllNames[i],"%14.4g",x[i+off],"%14.4g",std[i+off],"%14.4g",t[i+off]);
	  
	};	
}	

STR2::TFvalue(const x,const valg)
{
	decl tf,en,tf2;
	en=ones(rows(m_mX_linear),1);	
	if (m_iMethod==LSTR2) return tf = en ./ (en + exp( - x[0] * istd * (trvar - x[1] * en).*(trvar-x[2]*en)));
	else   {
	if (!valg) return tf = en ./ (en + exp( - x[0] * istd * (trvar - x[1] * en)));
	else return tf2 = en ./ (en + exp( - x[2] * istd2 * (trvar2 - x[3] * en))); }
}		

STR2::objektfn(const x,const adfunk,const avscore,const amhess)
{
    decl tf, cxlin, cxnonlin, offc, offu, ret, u,count,offset,en,cxnonlin2,offc2,tf2,bg2,offx;
	tf=TFvalue(x,0);
	if (m_iMethod==LSTR1_2) tf2=TFvalue(x,1);
	if (m_iMethod==LSTR1_2) offset=4; else offset=2;
	if (m_iMethod==LSTR2) offset=3;
	u = vYvar;
	cxlin = columns(m_mX_linear); 
    cxnonlin = columns(m_mX_nonlinear);
	cxnonlin2 = columns(m_mX_nonlinear2);
    offc = offset + cxlin;	 
	offc2 = offset + cxlin + cxnonlin;
    count = 0;
    c = x[offc++] * m_mX_nonlinear[][count++];
    while (count < cxnonlin)		  //non-linear part of model
    {
//		println("x[offc]:",x[offc]," ");
		c = c + (x[offc++] * m_mX_nonlinear[][count++]);
    }
	if (m_iMethod==LSTR1_2)
	{
		count = 0;
    	c2 = x[offc2++] * m_mX_nonlinear2[][count++];
    	while (count < cxnonlin2)		  //non-linear part of model 
    	{
			c2 = c2 + (x[offc2++] * m_mX_nonlinear2[][count++]);
    	}
	};	
    count = 0;
    while (count < (cxlin))  //linear part of model	  + cxnonlin
    {
		u = u - (x[offset++] * m_mX_linear[][count++]);
    }
    u = u - tf .* c;m_vTrFunc1=tf;
	if (m_iMethod==LSTR1_2) {u=u-tf2.*c2;m_vTrFunc2=tf2;}
	res_nlin=u;
	ret=(u'u);
//	print(adfunk[0]," ");
	adfunk[0]=-ret[0];
    return 1;
	
}

STR2::init()
{
    decl c_min,tell, tell2, pos, anull, beste, bg, bc1,bc2, tf, v, btest, bbeta,bsigma,
	ssr, kode, c1,c2, btf, csteg,alogdet,asign,beta,u,bv,tval,tf2,c3,c2_min,cstep2,g2,bg2,
	gstep,nimi,max1,max2,g,cstep,i,tell3,sigma,hjelp,std,mom,tell4,off,minus;
	oxwarning(0);
	g=start_gma;
	g2=start_gma2;
	tell = 1;pos = 0;
    beste = 100000;bg =-100;bc1=bc2 =-100;bbeta=0;
	c_min=min(trvar);
	if (m_iMethod==LSTR1_2) {c2_min=min(trvar2);cstep2 = (max(trvar2) - c2_min) / no_c;}
    cstep = (max(trvar) - c_min) / no_c;
	
	if (stegc!=0) cstep=stegc;
	if (cstep<0) cstep=-cstep;
	if (m_iMethod==LSTR1_2 && cstep2<0) cstep2=-cstep2;
	while (tell <= no_gma)
	{
	if (m_iMethod!=LSTR1_2) tell2=no_gma2;else {tell2=1;g2=start_gma2;}
	while (tell2<=no_gma2)
	{
		if (m_iMethod==LSTR1_2){ c2=c2_min; tell3=1;} else tell3=no_c;
		while (tell3<=no_c)
		{
			c1=c_min;tell4=1;
        	while (tell4 <= no_c)
        	{
				if (m_iMethod==ESTR) tf = 1 ./ (1 + exp( - g * istd[0][0] * (trvar - c1).^2));
				else tf = 1 ./ (1 + exp( - g * istd * (trvar - c1)));
				if (m_iMethod==LSTR1_2) tf2 = 1 ./ (1 + exp( - g2 * istd2 * (trvar2 - c2)));
				if (m_iMethod==LSTR1_2) v = m_mX_linear ~ (tf.*m_mX_nonlinear)~(tf2.*m_mX_nonlinear2);
				else  v = m_mX_linear~(tf.*m_mX_nonlinear);
				beta = invert(v'v) * v' vYvar;
            	u = vYvar - v * beta;
            	ssr = u' u;
				if (ssr < beste && beta !=0) 
            	{              
					++pos;
					m_InitialAdfunk=beste = ssr;
                	bg = g;
					if (m_iMethod==LSTR1_2){ bg2=g2;bc2 = c2;}
                	bc1 = c1;
                	bbeta = beta;
					bv=v;
            	}		
            	c1 = c1 + cstep;
           	 	tell4 = tell4 + 1;
        	}
			if (m_iMethod==LSTR1_2) c2=c2+cstep;
			++tell3;
			}
			tell2=tell2+1;
			if (m_iMethod==LSTR1_2) g2=g2+step_gma2;
		}	
    	g = g + step_gma;   
    	tell = tell + 1;
	}
	oxwarning(1);
	bsigma = sqrt(beste / (rows(vYvar) - rows(bbeta)));
	mom = invertsym(bv' bv);covar=bsigma*mom;
	if (mom==0){ std=ones(rows(bbeta),1);
		println("Standard deviations not computed because of singularity. Values set to 1");}
	else {	
	hjelp=sqrt(diagonal(mom));
	if (mom !=0) std = bsigma[0] .* hjelp';	}
	tval=bbeta./std;
	if (print_stval)
	{
    	print("Cstep: ", cstep,"\n");
		if (m_iMethod==LSTR1_2) print("Best g, c1, g2, c2 and ssr ", bg~bc1~bg2~bc2~beste,"\n");
		else
			print("Best g, c and ssr ", bg~bc1~beste,"\n");
		print("Number positive:",pos,"\n");
		Output(bbeta,std,tval,0,m_asAllNames);
	}
	print("\n\n");
	if (m_iMethod==LSTR1_2) return bg | bc1 | bg2 |bc2| bbeta;
	else return bg | bc1 | bbeta;
}

STR2::init2()
{
    decl c_min,tell, tell2, pos, anull, beste, bg, bc1,bc2, tf, v, btest, bbeta,bsigma,
	ssr, kode, c1,c2, btf, csteg, alogdet,asign,beta,u,bv,tval,
	gstep,nimi,max1,max2,g,cstep,i,tell3,sigma,hjelp,std,mom;
	oxwarning(0);
	g=start_gma;
	tell=1;pos = 0;anull=0;
    beste = 100000;bg = 100;bc1=bc2 = 100;bbeta=0;
	c_min=min(trvar);
    cstep = (max(trvar) - c_min) / no_c;
	if (stegc!=0) cstep=stegc;
	else
	if (cstep<0) cstep=-cstep;
    while (tell <= no_gma)
    {
		tell2=tell3=1;
		c1=c2=c_min;
		while (tell3<=no_c)
		{
		tell2=tell3+1;c2=c1+cstep;
		while (tell2 <= no_c)
        {
			tf = 1 ./ (1 + exp( - g * istd * (trvar - c1).*(trvar-c2)));                      
//			if (bZeroRestrictions) v = m_mX_linear ~ (tf.*m_mX_nonlinear);
//			else
			v = m_mX_linear ~ (tf.*m_mX_nonlinear);
			beta = invert(v'v) * v' vYvar;			
            if (beta==0) ++anull;
            u = vYvar - v * beta;
            ssr = u' u;
			if (ssr < beste && beta !=0 )
            {              
				++pos;
				m_InitialAdfunk=beste = ssr;
                bg = g;
                bc1 = c1;
				bc2 = c2;
                bbeta = beta;
				bv=v;
				bsigma = sqrt(ssr / (rows(vYvar) - rows(bbeta)));
            }		
            c2 = c2 + cstep;
            tell2 = tell2 + 1;
        }
		c1=c1+cstep;
		++tell3;
		}
        g = g + step_gma;
        tell = tell + 1;
    }
	oxwarning(1);
	mom = invertsym(bv' bv);
	if (mom==0){ std=ones(rows(bbeta),1);
		println("Standard deviations not computed because of singularity. Values set to 1");}
	else {	
	hjelp=sqrt(diagonal(mom));
	if (mom !=0) std = bsigma[0] .* hjelp';	}
	tval=bbeta./std;
	if (print_stval) {
    	print("Cstep: ", cstep,"\n");
		print("Best g, c1,c2 and ssr ", bg~bc1~bc2~beste,"\n");
		print("Number beta=0:",anull,"\n");
		print("Number positive:",pos,"\n");
		print("Estimates:\n");
	Output(bbeta,std,tval,0,m_asAllNames);
	}
	return bg | bc1 |bc2| bbeta;
}

STR2::STR2()				 //Constructor
{
	this.Modelbase();
//	MaxControl(1000,500);
//	MaxControlEps(0.0001,0.005); 
	print_funk=FALSE;
	print_stval=TRUE;
	lin_test=FALSE;
	no_gma=100;
	no_c=50;
	step_gma=1;
	start_gma=0;
	no_gma2=10;	
	step_gma2=1;
	start_gma2=0;
	stegc=0;
	TrErTrend=FALSE;
	TrErTrend2=FALSE;
	num2=TRUE;
	bZeroRestrictions=FALSE;
	draw_func=FALSE;
	draw_res=FALSE;
	res_stat=FALSE;
	reset=FALSE;
	addlin=FALSE;
	print_resi=FALSE;
	m_iMethod=LSTR1;
	nlin_index=0;
	bPrintVarCovarMatrix=FALSE;
}

STR2::ResStat(const value)
{
	res_stat=value;
}	

STR2::DrawTrfunc()
{
	if (m_vTrFunc1)
	{
//		println(GetYear1()," ",GetPeriod1()," ",GetFrequency()," ",GetSelInfo());
		DrawT(0,m_vTrFunc1[][0]',GetYear1()+2,GetPeriod1(),GetFrequency());
		if (m_iMethod==LSTR1_2) Draw(1,m_vTrFunc2[][0]',0,1);
		if (!draw_res) {ShowDrawWindow();draw_func=FALSE;}
	}
	else println("No values of transition function computed");
}	

STR2::DrawResiduals()
{
	
	if (res_lin && res_nlin)
	{
		decl m,h;
		if (m_iMethod==LSTR1_2) h=2;else h=1;
		if (!draw_func) h=0;
		m=res_lin~res_nlin;
		DrawMatrix(h,m',{"Linear","Non-linear"},0,1,2);
		ShowDrawWindow();
	}
	else println("No residuals computed");
	draw_res=FALSE;
	draw_func=FALSE;
}	

STR2::SetMethod(const value)
{
	m_iMethod=value;
}		

STR2::SetNoGamma(const value)
{
	no_gma=value;
}	

STR2::SetNoGamma2(const value)
{
	no_gma2=value;
}

STR2::SetNoC(const value)
{
	no_c=value;
}

STR2::SetStartC(const value)
{	
	startc=value;
}

STR2::SetStegC(const value)
{
	stegc=value;
}

STR2::SetStepGamma(const value)
{
	step_gma=value;
}

STR2::SetStepGamma2(const value)
{
	step_gma2=value;
}

STR2::SetStartGamma(const value)
{
	start_gma=value;
}

STR2::SetStartGamma2(const value)
{
	start_gma2=value;
}

STR2::PrintTrFunk(const value)
{
	print_funk=value;
}

STR2::LinTest(const value)
{
	lin_test=value;
}

STR2::PrintRes(const value)
{
	print_resi=value;
}

STR2::PrintStVal()
{
	print_stval=TRUE;
}

STR2::SetTrErTrend(const value)
{
	TrErTrend=value;
}

STR2::SetTrErTrend2(const value)
{
	TrErTrend2=value;
}

STR2::ResetTest(const value)
{
	reset=value;
}

STR2::AddLin(const value)
{
	addlin=value;
}	

STR2::SendVarStatus()
{
	return
	{{"&Y: Y variable",   'Y',STATUS_GROUP+STATUS_ENDOGENOUS,Y_VARS},
	 {"&L: Lin variable", 'L',STATUS_GROUP,X_LIN},
	 {"&N: Nlin variable",'N',STATUS_GROUP,X_NONLIN},
	 {"&T: Transvar",     'T',STATUS_GROUP2+STATUS_TRANSFORM,TR_VAR},
	 {"&n: Nlin var 2",   'n',STATUS_GROUP2,X_NONLIN2},
	 {"&t: Transvar 2",   't',STATUS_GROUP2+STATUS_TRANSFORM,TR_VAR2},
	 {"&r: Zero Restr.",  'r',STATUS_GROUP2,NULL}
	};
}

STR2::SendSpecial()
{
	return 0;
}

STR2::ReceiveData()
{
	Modelbase::ReceiveData();
}

STR2::SendMenu(const sMenu)
{
	if (sMenu=="Test")
		return
		{
		 	{"&Graphic Analysis","OP_TEST_GRAPHICS"},
			{"Linear Restrictions...","OP_TEST_LINRES"}
		};
}

STR2::DoSettingsDlg()
{
	decl asoptions, avalues, adlg;
	
	adlg =
		{
		 {"Alternatives:"},
	 	 {"Print starting values", CTL_CHECK, print_stval,"startverdier"},
	 	 {"Linear tests (pre-estimation)", CTL_CHECK, lin_test,"linear test"},
		 {"Print tr-function", CTL_CHECK, print_funk,"trfunk"},
		 {"Trend is tr.var1 ", CTL_CHECK, TrErTrend,"trendertr"},
		 {"Start gamma", CTL_INT, start_gma,"startgma"},
		 {"Step gamma", CTL_DOUBLE, step_gma,"stepgma"},
		 {"No of gamma", CTL_INT, no_gma,"nogma"},
		 {"Start gamma 2", CTL_INT, start_gma2,"startgma2"},
		 {"Step gamma 2", CTL_DOUBLE, step_gma2,"stepgma2"},
		 {"No of gamma 2", CTL_INT, no_gma2,"nogma2"},
		 {"Step C (optional)", CTL_DOUBLE, stegc,"stegc"},
		 {"No of C", CTL_INT, no_c,"antc"},
		 {"Use Num2Derivative()", CTL_CHECK, num2,"Num2"},
		 {"Residual statistics",CTL_CHECK,res_stat,"resstat"},
		 {"Draw tr-function",CTL_CHECK,draw_func,"tegnfn"},
		 {"Draw residuals",CTL_CHECK,draw_res,"tegnres"},
		 {"RESET-test",CTL_CHECK,reset,"reset"},
		 {"Test for remaining non-linearity",CTL_CHECK,addlin,"Addlin"},
		 {"Print residuals",CTL_CHECK,print_resi,"presi"},
		 {"Non-linear parameters in parameter constancy-test (ex 1;2;3)",CTL_STRMAT,nlin_index,"parstab"},
		 {"Trend is tr.var2 ", CTL_CHECK, TrErTrend2,"trendertr"}
		};
	if ("OxPackDialog"("Model Settings", adlg, &asoptions, &avalues))
	{
	 	if (avalues[0]) print_stval=TRUE;
		LinTest(avalues[1]);
	 	PrintTrFunk(avalues[2]);
	 	SetTrErTrend(avalues[3]);
	    SetStartGamma(avalues[4]);
		SetStepGamma(avalues[5]);
		SetNoGamma(avalues[6]);
		SetStartGamma2(avalues[7]);
		SetStepGamma2(avalues[8]);
		SetNoGamma2(avalues[9]);
		SetStegC(avalues[10]);
		SetNoC(avalues[11]);
	  	if (avalues[12]) num2=TRUE;
	  	ResStat(avalues[13]);
	  	if (avalues[14]) draw_func=TRUE;
	  	if (avalues[15]) draw_res=TRUE;
	  	ResetTest(avalues[16]);
		AddLin(avalues[17]);
		PrintRes(avalues[18]);
		nlin_index=avalues[19];
	  	SetTrErTrend2(avalues[20]);
		return TRUE;
	}
	return FALSE;
}
STR2::DoTestGraphicsDlg()
{
	decl asoptions, avalues;
	decl adlg =
		{	
			{"Alternatives:"},
			{"Draw transition fn", CTL_CHECK, draw_func,"tegnfunk"},
			{"Draw residuals", CTL_CHECK, draw_res,"tegnres"}
		};
		
		
	if ("OxPackDialog"("Graphic Analysis", adlg, &asoptions, &avalues))
	{
		if (avalues[0])
		{
			draw_res=TRUE;
			DrawTrfunc();
		}			
		if (avalues[1])
		{
			draw_func=TRUE;
			DrawResiduals();
		}
		return TRUE;
	}
	return FALSE;
}

STR2::ReceiveMenuChoice(const sMenu)
{
	if (sMenu == "OP_ESTIMATE")
	{
		return DoEstimateDlg(0, 4, "LSTR1|LSTR2|ESTR|LSTR1_2", TRUE, FALSE, FALSE);
	}
	else if (sMenu == "OP_TEST_GRAPHICS")
	{
		DoTestGraphicsDlg();
	}
	else
	{	// allow base class to process unhandled cases
		return Modelbase::ReceiveMenuChoice(sMenu);
	}
}

STR2::ReceiveModel()
{
	decl imethod, itforc, brecursive;	
	Select(Y_VARS,"OxPackGetData"("SelGroup",Y_VARS));
	Select(TR_VAR,"OxPackGetData"("SelGroup",TR_VAR));
	Select(TR_VAR2,"OxPackGetData"("SelGroup",TR_VAR2));
	Select(X_LIN,"OxPackGetData"("SelGroup",X_LIN));
	Select(X_NONLIN,"OxPackGetData"("SelGroup",X_NONLIN));
	Select(X_NONLIN2,"OxPackGetData"("SelGroup",X_NONLIN2));
	Select(NULL,"OxPackGetData"("SelGroup",NULL));

	Modelbase::ReceiveModel();
}	


STR2::greslix3(const gv, const ytest, const ytest1, const ytrans, const nimi, u)
{    
/* Variables to be imported:
gv = gradient vector   **** NOTE: GRADIENT HAS TO BE IMPORTED ****
ytest = variables included in the additional STR part of the model
ytest1 = variables reSTRicted in the gradient and freed when testing
ytrans = matrix of transition variables
nimi = names of the transition variables
u = residual vector */    
    
    decl dgma, dc, dgma1, dc1, yks, rd, nil, ynlg, ynlg1, id, ym, ytot, yltot, tol,
	ytot0, ydel, yl, yl2, yl3, yl4, yldim, detytot, eaux, rss, yobs, ydim, df, f,
	pval, ytot3, eaux3, rss3, ytot2, eaux2, rss2, ylg, j, y, ylag, knt, yln, silmu,
	yltot2, ytrs;
	tol=0.000000001;
    println(" ***************TESTS OF NO ADDITIVE NONLINEARITY***************** ");
	j=0;
	ytot0 = zeros(rows(gv), columns(gv));
    while (j < columns(gv))
    {
        if (meanc(gv[][j]) == 1)
        {
            ytot0[][j] = gv[][j];
        }
        else
        {
            ytot0[][j] = gv[][j] / sqrt(varc(gv[][j]));
			
        }
        j = j + 1;
    }
    
    /* Standardize the transition variable matrix */
    j = 0;
    ytrs = zeros(rows(ytrans), columns(ytrans));
    while (j < columns(ytrans))
    {
        if (meanc(ytrans[][j]) == 1)
        {
            ytrs[][j] = ytrans[][j];
        }
        else
        {
            ytrs[][j] = ytrans[][j] / sqrt(varc(ytrans[][j]));
        }
        j = j + 1;
    }   
/* Orthogonalize the residuals w.r.t. the gradient matrix
   (see Eitrheim and Terasvirta, 1996) */    
    u = u - ytot0 * invertsym(ytot0' ytot0) * ytot0' u;
    
    /* Rename the observation matrix of variables and standardize it */
    yl = ytest;

    yln = ytest1;
    j = 0;
    while (j < columns(yl))
    {
        if ( ! meanc(yl[][j]) == 1)
        {
            yl[][j] = yl[][j] / sqrt(varc(yl[][j]));
		
        }
        j = j + 1;
    }
    j = 0;
    if ( ! yln == 0)
    {
        while (j < columns(yln))
        {
            yln[][j] = yln[][j] / sqrt(varc(yln[][j]));
            j = j + 1;
        }
    }    
/* Start the big loop for testing having each variable in turn as
   transition variable */    
    id = 0;
    while (id < columns(ytrs))
    {
        ydel = ytrs[][id];
        
        /* Beginning of the testing part of the loop */
		println("\nTests of linearity:transition, variable, ",nimi[id]);
		println("The tests are F (linearity), 3rd order against 4th (F4), ");
		println("2nd order, against 3rd (F3)and linearity against 2nd order (F2)\n");

        /* Form the variables for the alternative hypothesis */
        yl2 = ydel .* yl;yl2 = yl2 ./ sqrt(varc(yl2));
        yl3 = (ydel .^ 2) .* yl;yl3 = yl3 ./ sqrt(varc(yl3));
        yl4 = (ydel .^ 3) .* yl;yl4 = yl4 ./ sqrt(varc(yl4));
        j = 0;
		//println("yl2 sdfsdf",yl2);
        while (j < columns(yl))
        {
			//println("yl2[][j] ",yl2);
			//println("j=",j);println("co yl ",columns(yl),"col yl2 ",columns(yl2),"rows yl2 ",rows(yl2)); 
            yl2[][j] = yl2[][j] / sqrt(varc(yl2[][j]));
            yl3[][j] = yl3[][j] / sqrt(varc(yl3[][j]));
            yl4[][j] = yl4[][j] / sqrt(varc(yl4[][j]));
            j = j + 1;
        }
                
/* Loop for carrying out the two types of no nonlinearity tests
   (1) Ignoring the holes
   (2) All information (including the holes) */        
        silmu = 1;
        while (silmu <= 2)
        {
            if (silmu == 1)
            {
                println("******* TESTS OF NO ADDITIVE NONLINEARITY IGNORING THE 'HOLES' *********");
				yltot=yl2~yl3~yl4;
				
                yltot2 = yl2;
            }
            else
            {
                println(" ******TESTS OF NO ADDITIVE NONLINEARITY NOT IGNORING THE 'HOLES'**********");
				yltot=yln~yl2~yl3~yl4;
			
                yltot2 = yln ~ yl2;
            }
            
            yldim = columns(yltot);
            ytot = ytot0 ~ yltot;
            ytot2 = ytot0 ~ yltot2;
            detytot = determinant(ytot' ytot);

            if (detytot <tol)
            {
                println("Test not computed. Moment matrix near-singular.");
                yobs = rows(ytot);ydim = columns(ytot);df = yobs - ydim;
                goto d;
            }
            
            /* Estimate the auxiliary regression and compute the residual sum of squares */
            eaux = u - ytot * invert(ytot' ytot) * ytot' u;
            rss = eaux' eaux;
            
            /* Compute the F test */
            yobs = rows(ytot);
            ydim = columns(ytot);
            df = yobs - ydim;
            f = ((u' u - rss) / yldim) / (rss / df);
            pval = tailf(f, yldim, df);
            
            /* Print the results */
            print("Value of the F statistic, degrees of freedom and p-value");
            print("%8.3g", f~yldim~df~pval, "\n");
            
            /* *** Test 3rd degree against 4th *** */
            if (silmu == 1)
            {
                ytot3 = ytot0 ~ yl2 ~ yl3;
            }
            else
            {
                ytot3 = ytot0 ~ yln ~ yl2 ~ yl3;
            }
            detytot = determinant(ytot3' ytot3);
            if (detytot <tol)
        {goto c;}
            eaux3 = u - ytot3 * invert(ytot3' ytot3) * ytot3' u;
            rss3 = eaux3' eaux3;
            
            /* Compute the F test */
            yobs = rows(ytot3);
            df = yobs - ydim;
            yldim = columns(yl3);
            f = ((rss3 - rss) / yldim) / (rss / df);
            pval = tailf(f, yldim, df);
            
            /* Print the results */
            print("%8.3g", f~yldim~df~pval, "\n");
            
            /* *** Test 3rd degree against 2nd *** */
            if (silmu == 1)
            {
                ytot2 = ytot0 ~ yl2;
            }
            else
            {
                ytot2 = ytot0 ~ yln ~ yl2;
            }
            detytot = determinant(ytot2' ytot2);
            if (detytot == 0)
            {
                goto d;
            }
            
            eaux2 = u - ytot2 * invert(ytot2' ytot2) * ytot2' u;
            rss2 = eaux2' eaux2;
            
            /* Compute the F test */
            yobs = rows(ytot2);ydim = columns(ytot3);
            df = yobs - ydim;yldim = columns(yl2);
            f = ((rss2 - rss3) / yldim) / (rss3 / df);
            pval = tailf(f, yldim, df);
            
            /* Print the results */
            print("%8.3g", f~yldim~df~pval, "\n");
            
            /* *** Test linearity against 2nd order (LSTR) *** */
            /* Compute the F test */
            
:d
            detytot = determinant(ytot2' ytot2);
            if (detytot <tol)
            {
                println("Test against LSTR not computed. Moment matrix near-singular. ");
                goto c;
            }
            eaux2 = u - ytot2 * invert(ytot2' ytot2) * ytot2' u;
            rss2 = eaux2' eaux2;
            yobs = rows(ytot2);
            ydim = columns(ytot2);
            df = yobs - ydim;
            yldim = columns(yl2);
            f = ((u' u - rss2) / yldim) / (rss2 / df);
            pval = tailf(f, yldim, df);
            
            /* Print the results */
            print("%8.3g", f~yldim~df~pval, "\n");
            
            if ( ! yln == 0)
            {
                silmu = silmu + 1;
            }
            else
            {
                silmu = 999;
            }
            
        } /* End of loop "silmu" */
        
        /* *** Test of linear misspecification *** */
        if (id == 0)
        {
            println("************Tests of no missing linear terms, (lags)**************");
			if (yln!=0)
            yltot = yln;
            yldim = columns(yltot);
            ytot = ytot0 ~ yltot;
            detytot = determinant(ytot' ytot);
            
            if (detytot == 0)
            {
                println("Test not computed. Moment matrix near-singular.");
                yobs = rows(ytot);
                ydim = columns(ytot);
                df = yobs - ydim;
                goto c;
            }
            
            /* Estimate the auxiliary regression and compute the residual sum of squares */
            eaux = u - ytot * invert(ytot' ytot) * ytot' u;
            rss = eaux' eaux;
            
            /* Compute the F test */
            yobs = rows(ytot);
            ydim = columns(ytot);
            df = yobs - ydim;
            f = ((u' u - rss) / yldim) / (rss / df);
            pval = tailf(f, yldim, df);
            
            /* Print the results */
            println("Value of the F statistic, degrees of freedom and p-value");
            print("%8.3g", f~yldim~df~pval, "\n");
        }
        else
        {
            println("Test not computed: no missing regressors.");
        }
   // }
    
    /* Start new round */
    
:c
    id = id + 1;
    
}
/* End of loop for computing the test for a given transition
          variable */
}
STR2::gresac1(u, const gv, q, const knt)
{    
/* Variables to be imported:
u  = residual vector
gv  = gradient vector or relevant parts of it
q   = degree of autocorrelation in the test
knt = counter for printing headline (print if knt=1) */    
    
    /* Define the local variables */
    decl dgma, dc, dgma1, dc1, yks, rd, nil, id, ym, ytot, ytot0, ydel, df, f,
	pval, eaux, uuq, rss, j, ylg, ylag, ynlg, ynlg1, coll, colnl, colnl1,
	ulag, ulg, detytot, ydim, yobs, hjelp;
    
    if (knt == 1)
    {
        println(" **********Tests of no remaining error autocorrelation**********");
	}
        
        
/* Orthogonalize the residuals w.r.t. the gradient matrix
   (see Eitrheim and Terasvirta, 1995) */        
        u = u - gv * invertsym(gv' gv) * gv' u;
        
        
/* Form the lags of the residuals:
   NOTE: The unobserved elements in the beginning are set equal to zero:
   no trimming of lag vectors! (Change made on March 9, 1996) */        
        j = 0;
        while (j < q)
        {
			ulag = zeros(j+1, 1) | u[:rows(u)-j-2][];
            if (j == 0)
            {
                ulg = ulag;
            }
            else
            {
                ulg = ulg ~ ulag;
            }
            j = j + 1;
        }      
        /* Centre the variables */
        uuq = u;
        ytot = gv;
        j = 0;
        while (j < columns(ytot))
        {
            if (meanc(gv[][j]) == 1)
            {
                ytot[][j] = ytot[][j];
            }
            else
            {
                ytot[][j] = ytot[][j] - meanc(ytot[][j]); /* Centre in case no intercept */
            }
            j = j + 1;
        }
        
        /* Standardize the gradient vector */
        j = 0;
        while (j < columns(gv))
        {
            if (meanc(gv[][j]) == 1)
            {
                ytot[][j] = ytot[][j];
            }
            else
            {
                ytot[][j] = ytot[][j] / sqrt(varc(ytot[][j]));
            }
            j = j + 1;
        }
        
        /* Another centring and orthogonalization */
        uuq = uuq - meanc(uuq);  /* Re-centre the residuals */
        uuq = uuq - ytot * invertsym(ytot' ytot) * ytot' uuq; /* Orthogonalize once more! */
        
        /* If no linear constant or constant reSTRicted add constant */
        yks = ones(rows(ytot), 1);
        ytot = (ulg / sqrt(varc(u))) ~ ytot;
        
        uuq = uuq / sqrt(varc(uuq));
        detytot = determinant(ytot' ytot);
        /*if detytot<0.1;k=k-1;goto a;endif;*/
        
        /* Estimate the auxiliary regression and compute the residual sum of squares */
        eaux = uuq - ytot * invertsym(ytot' ytot) * ytot' uuq;
        rss = eaux' eaux;
        
        /* Compute the F test */
        yobs = rows(ytot);
        ydim = columns(ytot);
        df = yobs - ydim;
        f = ((uuq' uuq - rss) / q) / (rss / df);
        pval = tailf(f, q, df);
        
        /* Print the results */
        /*print "detytot " detytot;*/
        if (knt == 1)
        {
            println("lm test of no error autocorrelation:number of lags,");
			println("value of the f statistic, degrees of freedom and p-value");
		}
		print(q~f~q~df~pval, "\n");
        
		
}

STR2::gressc1(const gv, const gvtest1, const gvtest2, uu, const skp)
{   
/* Variables to be imported:
gv = gradient vector
gvtest1 = gradient vector for parameters under test (Test #1)
gvtest2 = gradient vector for parameters under test (Test #2)
uu  = residual vector
skp = selector of tests: skp=1: all tests, skp=0: first-order tests
      only */    
    
    decl yks, rd, nil, ynlg, ynlg1, id, ym, ytot, yltot, ytot0, ytot1, ytot11, yl2, yl3, yl4, yldim, detytot, eaux, rss, yobs, ydim, df, f, pval, ytot3, eaux3, rss3, ytot2,
	eaux2, rss2, ylg, j, y, ylag, coll, colnl, colnl1, rowt, t, t2, t3, ypar, rss0, knt,i1,i2,enm;
    
    println("****************Tests of parameter constancy****************");
	j=0;
    ytot0 = zeros(rows(gv), columns(gv));
    while (j < columns(gv))
    {
        if ( meanc(gv[][j]) != 1)
        {

			ytot0[][j] = gv[][j] / sqrt(varc(gv[][j]));
        }
        else
        {
            ytot0[][j] = gv[][j];
        }
        j = j + 1;
    }
    j = 0;
    ytot1 = zeros(rows(gvtest1), columns(gvtest1));
    while (j < columns(gvtest1))
    {
        if (meanc(gvtest1[][j]) != 1)
        {
            ytot1[][j] = gvtest1[][j] / sqrt(varc(gvtest1[][j]));
        }
        else
        {
            ytot1[][j] = gvtest1[][j];
        }
        j = j + 1;
    }
	
    ytot11 = zeros(rows(gvtest2), columns(gvtest2));
    j = 0;
    while (j < columns(gvtest2))
    {
        if (meanc(gvtest2[][j]) != 1)
        {
            ytot11[][j] = gvtest2[][j] / sqrt(varc(gvtest2[][j]));
        }
        else
        {
            ytot11[][j] = gvtest2[][j];
        }
        j = j + 1;
    }
    
/* Orthogonalize the residuals w.r.t. the gradient matrix
   (see Eitrheim and Terasvirta, 1994) */    
    uu = uu - ytot0 * invertsym(ytot0' ytot0) * ytot0' uu;
    /* Form the remaining auxiliary regressors */
    rowt = rows(ytot0);
	enm=zeros(1,rowt);
	for (i1=0;i1<rowt;++i1) enm[0][i1]=i1+1;
	enm=enm';
    t = (1 / rowt) * enm - 0.5;
    t2 = t .* t;
    t3 = t .* t2;
    t = t / sqrt(varc(t));
    t2 = t2 / sqrt(varc(t2));
    t3 = t3 / sqrt(varc(t3));
    /* Beginning of the loop */
    println("Lm tests of parameter constancy:the tests are lm3, lm2 and lm1");
	knt=1;
    while (knt <= 1)
    {
        if (knt == 1)
        {
            println("Parameter selection (1) ");
        }
        else
        {
            println("Parameter selection (2) ");
        }    
            /* Form the variables for the alternative hypothesis */
            if (knt == 1)
            {
                yl2 = t .* ytot1;
                yl3 = t2 .* ytot1;
                yl4 = t3 .* ytot1;
                j = 0;
                while (j < columns(yl2))
                {
                    yl2[][j] = yl2[][j] / sqrt(varc(yl2[][j]));
                    yl3[][j] = yl3[][j] / sqrt(varc(yl3[][j]));
                    yl4[][j] = yl4[][j] / sqrt(varc(yl4[][j]));
                    j = j + 1;
                }
            }
            else
            {
                yl2 = t .* ytot11;
                yl3 = t2 .* ytot11;
                yl4 = t3 .* ytot11;
                j = 0;
                while (j <= columns(yl2))
                {
                    yl2[][j] = yl2[][j] / sqrt(varc(yl2[][j]));
                    yl3[][j] = yl3[][j] / sqrt(varc(yl3[][j]));
                    yl4[][j] = yl4[][j] / sqrt(varc(yl4[][j]));
                    j = j + 1;
                }
            }
            rss0 = uu' uu;
            
            
/* Skip the higher-order tests if skp=0 (skp=0, no higher order tests,
skp=1, all tests) */            
            if (skp == 0)
            {
                goto a;
            }
            yltot = yl2 ~ yl3 ~ yl4;
            yldim = columns(yltot);
            
            ytot = ytot0 ~ yltot;
            detytot = determinant(ytot' ytot);
            /*print "detytot " detytot;*/
            
            if (detytot < 0.00000001)
            {
                println("Test not computed. Moment matrix near-singular.");
                yobs = rows(ytot);ydim = columns(ytot);df = yobs - ydim;
                goto c;
            }
            
            /* Estimate the auxiliary regression and compute the residual sum of squares */
            eaux = uu - ytot * invert(ytot' ytot) * ytot' uu;
            rss = eaux' eaux;
            
            /* Compute the F test */
            yobs = rows(ytot);ydim = columns(ytot);
            df = yobs - ydim;
            f = ((rss0 - rss) / yldim) / (rss / df);
            pval = tailf(f, yldim, df);
            
            /* Print the results */
            println("Value of the F statistic, degrees of freedom and p-value");
            print(f~yldim~df~pval, "\n");
            
            ytot3 = ytot0 ~ yl2 ~ yl3;
            detytot = determinant(ytot3' ytot3);
            /*print "detytot (LSTAR)" detytot;*/
            if (detytot < 0.00000001)
        	{goto c;}
            
            eaux3 = uu - ytot3 * invert(ytot3' ytot3) * ytot3' uu;
            rss3 = eaux3' eaux3;
            
            /* Compute the F test */
            yobs = rows(ytot3);
            ydim = columns(ytot3);
            df = yobs - ydim;
            yldim = 2 * columns(yl2);
            f = ((rss0 - rss3) / yldim) / (rss3 / df);
            pval = tailf(f, yldim, df);
            
            /* Print the results */
            print(f~yldim~df~pval, "\n");
            
            
:a
            ytot2 = ytot0 ~ yl2;
            detytot = determinant(ytot2' ytot2);
            /*print "detytot (LSTAR)" detytot;*/
            if (detytot < 0.00000000001)
            {
                goto c;
            }
            
            eaux2 = uu - ytot2 * invert(ytot2' ytot2) * ytot2' uu;
            rss2 = eaux2' eaux2;
            
            /* Compute the F test */
            yobs = rows(ytot2);
            ydim = columns(ytot2);
            df = yobs - ydim;
            yldim = columns(yl2);
            f = ((rss0 - rss2) / yldim) / (rss2 / df);
            pval = tailf(f, yldim, df);
            
            /* Print the results */
            print(f~yldim~df~pval, "\n");
            if (detytot < 0.00000000001)
            {
                
:c
                println("Test not computed because of moment matrix singularity.");
            }
            
            knt = knt + 1;
        }
}		
STR2::gacf1(const um, const laglb, const nreg, const lagml, const knt, const kntmax)
{
    decl n, dif, x, xmn, xsd, xx, xxm, lag, nac, np, lagc, t, z, tj, i, z0, ac, bp,
		acw, pv, bpv, z2, xm, mli, mlipv, z2a, z2m, b2, e2, ssr, f, lmpv, x3, z3a,
		e3, ssr3, ssr0, lag2, sk, ek, jb, jbpv, z20, yks, z3m, b3, x4, x3m, x4m,
		xlm, x15m, lmpv1, lmpv2, lmpv3, lmpvv, kac, z4m, b4, lmpv4, lmpv5, z4a, e4, ssr4,i2;
    
    
/* Variables to be imported
   um = the residual series
   laglb = number of lags in the Ljung-Box statistic
   nreg = number of lags in the AR part of the model
   lagml = number of lags in the McLeod and Li statistic
   knt =  the order of autocorrelation in the McLeod and
          Li statistic
   kntmax =  number of times the Mcleod and Li statistic is
             computed or the longest lag in the test statistic */    
    
    /* Load the data */
    x = um;
    n = rows(x);
    /* If dif=1, take first differences */

	dif = 0;

	if (dif == 1)
	{	x = x[1:n-1][0] - x[0:n-1][0];
		n = rows(x);
	}
	xmn = meanc(x);
	x = x - xmn;xsd = sqrt(variance(x));
    
    /* Print general statistics and header */
    if (knt == 1)
    {
        println(" *******ljung-box mcleod-li lm-arch lomnicki-jarque-bera********");
		println("mean of the series is ", xmn);
		println("Standard deviation is ", xsd);
        println("The number of observations (n) is ", n);
        println("2/sqrt(n) is                      ", 2/sqrt(n));
    }
    else
    {
        println(" ********************mcleod and li and lm-arch*********************");
	}	
        
        /* Square the residuals and centre the squares */
        xx = x .* x;xm = meanc(xx);xxm = xx - xm * ones(n, 1);
        
        /* Lag length in Ljung-Box statistic */
        lag = laglb;
		nac=zeros(1,lag);
		for (i2=0;i2<lag;++i2) nac[0][i2]=i2+1; //+1 ?
		nac=nac';
        //nac = seqa(1, 1, lag);
        
        /* If the data are residuals from an AR model, give the # of parameters */
        np = nreg;lagc = lag - np;
        
        /* Compute the autocorrelations */
        t = n - lag;
		println("t ",t);
        z = zeros(t, lag);
        tj = zeros(lag, 1);
        i = 0;
        while (i < lag)
        {
			z[][i] = x[lag-i-1:n-i-1][0];  //var +1-i
            tj[i][0] = t - i-1;
            i = i + 1;
        }
        z0 = x[lag:n-1][0];
        ac = z' z0 / (z0' z0);
        acw = ac ./ tj;
        /* Compute the Ljung-Box statistic and print the results */
        if (knt == 1)
        {
            println(" the autocorrelatins are:");
			println("lag autocorrelation", nac~ac);
            bp = t * (t + 2) * acw' ac;pv = tailchi(bp, lagc);bpv = bp | pv;
            println("the ljung-box statistic and p-value are ", bpv');
			println("with ",lag," autocorrelations");
        }
        
        /* Lag length in McLeod and Li statistic */
        lag = lagml;
        t = n - lag;i = 0;z2 = zeros(t, lag);tj = zeros(lag, 1);
        while (i < lag)
        {
            z2[][i] = xxm[lag-1-i:n-i-1][0];
            tj[i][0] = t - i-1;
            i = i + 1;
        }
		//println("rader z2 ",rows(z2));
        z0 = xxm[lag:n-1][0];ac = z2' z0 / (z0' z0);acw = ac ./ tj;
		//println("rader z0 ",rows(z0));
        if (knt == kntmax)
        {
			kac=zeros(1,rows(ac));
			for (i2=0;i2<rows(ac);++i2) kac[0][i2]=i2+1;
			kac=kac';
            //kac = seqa(1, 1, rows(ac));
            
            println("the autocorrelations of squares are:");
			println("lag autocorrelation");
			print(kac~ac);
        }
        mli = t * (t + 2) * acw' ac;pv = tailchi(mli, lag);mlipv = mli | pv;
        println(" the mcleodandli statistic and p-value are ", mlipv');
		println("with ", lag, " autocorrelations");
        
        /* Compute LM statistic of no ARCH */
        
        t = n - lag;z2a = zeros(t, lag);
        i = 0;while (i < lag)
	    {z2a[][i] = xx[lag-1-i:n-i-1][0];i = i + 1;}
        z20 = xx[lag:n-1][0];yks = ones(t, 1);z2a = yks ~ z2a;
        z2m = z2a' z2a;b2 = invertsym(z2m) * z2a' z20;
        e2 = z20 - z2a * b2;ssr = e2' e2;ssr0 = z0' z0;
        f = ((ssr0 - ssr) / lag) / (ssr / (t - lag - 1));
        pv = tailf(f, lag, t - lag - 1);
        lmpv1 = f ~ pv;
        println("The LM statistic of no ARCH and p-value are            ", lmpv1);
        
        /* Compute augmented LM statistic of no ARCH */
        x3 = x .* xx;
        z3a = zeros(t, lag);
        i = 0;while (i < lag)
	    {z3a[][i] = x3[lag-1-i:n-i-1][0];i = i + 1;}
        z3a = z2a ~ z3a;
        z3m = z3a' z3a;b3 = invertsym(z3m) * z3a' z20;
        e3 = z20 - z3a * b3;ssr3 = e3' e3;ssr0 = z0' z0;lag2 = 2 * lag;
        f = ((ssr0 - ssr3) / lag2) / (ssr3 / (t - lag2 - 1));
        pv = tailf(f, lag2, t - lag2 - 1);
        lmpv2 = f ~ pv;
        println("The augmented LM statistic of no ARCH and p-value are  ", lmpv2);
        
        /* Compute nonlinear ARCH (3rd order) test */
        f = ((ssr - ssr3) / lag) / (ssr3 / (t - lag2 - 1));
        pv = tailf(f, lag, t - lag2 - 1);
        lmpv3 = f ~ pv;
        println("The LM statistic of linear ARCH and p-value are        ", lmpv3);
        
        /* Compute LM statistic of no GMACH4 */
        x4 = xx .* xx;
        z4a = zeros(t, lag);
        i = 0;
        while (i < lag)
        {
            z4a[][i] = x4[lag-i-1:n-i-1][0];
            i = i + 1;
        }
       	 //print("z4a ",z4a);
        /* Standardization */
        z4a = z4a / sqrt(variance(z4a[][0]));
       	
        z4a = z2a ~ z4a;
        z4m = z4a' z4a;
        
        b4 = invertsym(z4m) * z4a' z20;
        e4 = z20 - z4a * b4;
        ssr4 = e4' e4;ssr0 = z0' z0;lag2 = 2 * lag;
        f = ((ssr0 - ssr4) / lag2) / (ssr4 / (t - lag2 - 1));
        pv = tailf(f, lag2, t - lag2 - 1);
        lmpv4 = f ~ pv;
        println("The LM statistic of no GMACH(4) and p-value are        ", lmpv4);
        
        /* Compute linear ARCH (4th order) test */
        f = ((ssr - ssr4) / lag) / (ssr4 / (t - lag2 - 1));
        pv = tailf(f, lag, t - lag2 - 1);
        lmpv5 = f ~ pv;
        println("The LM statistic of linear GMACH and p-value are       ", lmpv5);
        lmpvv = lmpv1[][1] ~ lmpv2[][1] ~ lmpv3[][1] ~ lmpv4[][1] ~ lmpv5[][1];
        
        if (knt == 1)
        {
            /* Compute Lomnicki-Jarque-Bera normality test */
            x4 = xx .* xx;x3m = meanc(x3);x4m = meanc(x4);x15m = xm * sqrt(xm);
            
               /* Skewness */
            sk = x3m / x15m;
            println("skewness ", sk);
			ek=x4m/(xm*xm)-3;
            println("Excess kurtosis                                       ", ek);
            
            
/* Jarque-Bera statistic (see Hendry (1989), p. 32-33; however note the
   statistic here computed without the finite sample correction) */            
            jb = (n / 6) * (sk * sk + 0.25 * ek * ek);
            pv = tailchi(jb, 2);jbpv = jb ~ pv;
            println("The Lomnicki-Jarque-Bera statistic and p-value are    ", jbpv);
        }
        
        /* Returns the ARCH, augmented ARCH, and nonlinear ARCH statistics */
        /*retp(lmpvv);*/
		
}
STR2::greset1(const gv, const yhat, const r, u)
{
    
    
/* Variables to be imported:
gv = gradient vector   **** NOTE: GRADIENT HAS TO BE IMPORTED ****
yhat = the fit of the model (y=yhat+u)
r = maximum power of the fit in the test
u = residual vector */    
    
    decl dgma, dc, dgma1, dc1, yks, rd, nil, ynlg, ynlg1, id, ym, ytot, yltot, ytot0, ydel, yl, yl2, yl3, yl4, yldim, detytot, eaux, rss, yobs, ydim, df, f, pval, ytot3, eaux3, rss3, ytot2, eaux2, rss2, ylg, j, y, ylag, knt, yln, silmu, yltot2, k;

	println("*****************************Reset******************************");
	j=0;
    ytot0 = zeros(rows(gv), columns(gv));
    while (j < columns(gv))
    {
        if (meanc(gv[][j]) == 1)
        {
            ytot0[][j] = gv[][j];
        }
        else
        {
            ytot0[][j] = gv[][j] / sqrt(varc(gv[][j]));
        }
        j = j + 1;
    }
    
    
/* Orthogonalize the residuals w.r.t. the gradient matrix
   (see Eitrheim and Terasvirta, 1994) */    
    u = u - ytot0 * invertsym(ytot0' ytot0) * ytot0' u;
    
    /* Rename the observation matrix of variables and standardize it */
    yl = yhat;
    
    /* Form the matrix of powers of fit */
    k = 2;
    yl = zeros(rows(gv), r - 1);
    while (k <= r)
    {
        yl[][k-2] = yhat .^ k;
        k = k + 1;
    }
    
    j = 0;
    while (j < columns(yl))
    {
        if (meanc(yl[][j]) != 1)
        {
            yl[][j] = yl[][j] / sqrt(varc(yl[][j]));
        }
        j = j + 1;
    }
    
    /* Beginning of the testing part of the loop */

    /* *** Test of linear misspecification *** */
    yldim = columns(yl);
    ytot = ytot0 ~ yl;
    detytot = determinant(ytot' ytot);
    /*print "detytot " detytot;*/
    
    if (detytot < 0.00000001)
    {
        println("Test not computed. Moment matrix near-singular.");
        yobs = rows(ytot);
        ydim = columns(ytot);
        df = yobs - ydim;
        goto c;
    }
    
    /* Estimate the auxiliary regression and compute the residual sum of squares */
    eaux = u - ytot * invert(ytot' ytot) * ytot' u;
    rss = eaux' eaux;
    
    /* Compute the F test */
    yobs = rows(ytot);
    ydim = columns(ytot);
    df = yobs - ydim;
    f = ((u' u - rss) / yldim) / (rss / df);
    pval = tailf(f, yldim, df);
    
    /* Print the results */
    println("Value of the F statistic, degrees of freedom and p-value");
    print("%8.4g", f~yldim~df~pval, "\n");
        
:c
}		
        
